<?php
/* Include Files ***************************/
require_once('../../db-config.php');
require_once('../../inc/lib-compat-class.php');
require_once('../../inc/lib-db-class.php');
require_once('../../inc/lib-login-class.php');
require_once('../../JSON/jsonwrapper_inner.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('get-data', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

if(  $_POST['what']=='tags'  )
	die( getRecipeTags() );
else if(  $_POST['what']=='all'  )
	die( getAllRecipeNames() );
else if(  $_POST['what']=='a-z'  )
	die( getAllRecipeNamesA_Z() );
else if(  $_POST['what']=='emails'  )
	die( getAllEmails() );


function getRecipeTags() {
	global $rSdb;
	
    $rSdb->all_recipies = $rSdb->fetchArr("SELECT tags FROM {$rSdb->DBrecipes}");

	$letter	= '';
	$resArr = array();

    if( count($rSdb->all_recipies)==0 ){

		$resArr[0]->result = 0;
		$resArr[0]->n = 0;
		$resArr[0]->o = __('No entries available yet!','recipeshelf');

    }else{
		$resArr[0]->result = 1;

        $allT = array();
        $tmpT = array();
        foreach( $rSdb->all_recipies as $r ){
            $tmpT = explode(',',$r->tags);
            foreach( $tmpT as $t ){
                $t = strtolower($t);
                if ( !array_key_exists($t, $allT) )
                    $allT[$t] = 0;
                $allT[$t]++;
            }
        }
        ksort($allT);

		$i=0;
        foreach( $allT as $t=>$v )
            if( strlen($t)>2 ){

				$tL = substr(utf8_decode($t),0,1);

   				if( $letter <> $tL ){
                    $letter = $tL;
					$resArr[$i]->n = -1;
					$resArr[$i++]->o = utf8_encode($letter);
				}
				$resArr[$i]->n = esc_html($v);
				$resArr[$i++]->o = esc_html($t);
			}
    }

	return json_encode($resArr);
}



function getAllRecipeNames() {
	global $rSdb;

    $rSdb->all_recipies = $rSdb->fetchArr("SELECT id,name,UNIX_TIMESTAMP(date_added) as date_added FROM {$rSdb->DBrecipes} ORDER BY date_added DESC");

	$done	 	= array (false,false,false,false,false);
	$resArr 	= array();

    if( count($rSdb->all_recipies)==0 ){

		$resArr[0]->result = 0;
		$resArr[0]->n = 0;
		$resArr[0]->o = __('No entries available yet!','recipeshelf');

	} else{

		$resArr[0]->result = 1;

		$i=0;
        foreach( $rSdb->all_recipies as $r ){

		$d = $r->date_added;

			$resArr[$i]->n = -1;  // may change later!
			if(							 	$d > time()-604800   && !$done[0] ) { $resArr[$i++]->o = __('This week','recipeshelf'); $done[0]=true; }
			else if( time()-604800  > $d && $d > time()-1209600  && !$done[1] ) { $resArr[$i++]->o = __('Two weeks ago','recipeshelf'); $done[1]=true; }
			else if( time()-1209600 > $d &&	$d > time()-2419200  && !$done[2] ) { $resArr[$i++]->o = __('A month ago','recipeshelf'); $done[2]=true; }
			else if( time()-2419200 > $d &&	$d > time()-29030400 && !$done[3] ) { $resArr[$i++]->o = __('A year ago','recipeshelf'); $done[3]=true; }
			else if( 						$d < time()-29030400 && !$done[4] ) { $resArr[$i++]->o = __('Older','recipeshelf'); $done[4]=true; }

            $t = (strlen($r->name)<81) ? $r->name : substr($r->name,0,80).'...';
            
			$resArr[$i]->n   = $r->id;
			$resArr[$i++]->o = esc_html($t);
        }
    }

	return json_encode($resArr);
}

function getAllRecipeNamesA_Z() {
	global $rSdb;

    $rSdb->all_recipies = $rSdb->fetchArr("SELECT id,name,UNIX_TIMESTAMP(date_added) as date_added FROM {$rSdb->DBrecipes} ORDER BY date_added DESC");

	$letter	= '';
	$resArr = array();

    if( count($rSdb->all_recipies)==0 ){

		$resArr[0]->result = 0;
		$resArr[0]->n = 0;
		$resArr[0]->o = __('No entries available yet!','recipeshelf');

	}else{
	
		$resArr[0]->result = 1;

		$i		= 0;
        $allT	= array();
        foreach( $rSdb->all_recipies as $r )
			$allT[$r->name] = $r->id;

        ksort($allT);
        
        foreach( $allT as $t=>$v ){

			$tL = substr(utf8_decode($t),0,1);

 				if( $letter <> $tL ){
                  $letter = $tL;
				$resArr[$i]->n = -1;
				$resArr[$i++]->o = utf8_encode($letter);
			}

            $t = (strlen($t)<81) ? $t : substr($t,0,80).'...';
			$resArr[$i]->n   = esc_html($v);
			$resArr[$i++]->o = esc_html($t);
        }
    }

	return json_encode($resArr);
}
  
  
function getAllEmails() {
	global $rSdb, $user;

    $emails = $rSdb->fetchArr("SELECT object FROM {$rSdb->DBobjects} WHERE type='4' AND uid='{$user->_user_id}' ORDER BY object DESC");

	$letter	= '';
	$resArr = array();

    if( count($emails)==0 ){

		$resArr[0]->result = 0;
		$resArr[0]->n = 0;
		$resArr[0]->o = __('No entries available yet!','recipeshelf');

	}else{

		$resArr[0]->result = 1;

		$i=0;
        foreach( $emails as $e ){

            $t = $e->object;
            
			$tL = substr($t,0,1);

			if( $letter <> $tL ){
                $letter = $tL;
				$resArr[$i]->n = -1;
				$resArr[$i++]->o = $letter;
			}

            $t = (strlen($t)<81) ? $t : substr($t,0,80).'...';
			$resArr[$i]->n   = '';
			$resArr[$i++]->o = esc_html($t);
        }

	}

	return json_encode($resArr);
  }
?>