<?php
/* Include Files *********************/
require_once('require.php');
require_once('../../JSON/jsonwrapper_inner.php');
/*************************************/

global $rSdb;

$user	= new userManagement();

if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('get-cats', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));


$rS_options = $rSdb->get_option("recipeShelf_options");

$arrFlip  = array_flip( $rS_options["rS_season"] );
$arrFlip  = mergeArr( $arrFlip, $rS_options["rS_course"] );
$arrFlip  = mergeArr( $arrFlip, $rS_options["rS_cuisine"] );
$arrFlip  = mergeArr( $arrFlip, $rS_options["rS_type"] );
$arrFlip  = mergeArr( $arrFlip, $rS_options["rS_additional"] );
$arrFlip  = mergeArr( $arrFlip, $rS_options["rS_diet"] );

if( is_array($rS_options["rS_custom"]) && count($rS_options["rS_custom"])>0 ){
	foreach( array_keys($rS_options["rS_custom"]) as $user ){
        	$arrFlip  = mergeArr( $arrFlip, $rS_options["rS_custom"][$user],$user );
    }
}

$cats = Array();

if ( !is_array($arrFlip) || count($arrFlip)==0 ){

	$cats[0]->result = 0;
	$cats[0]->n = 0;
	$cats[0]->o = __('No ideas yet...','recipeshelf');
	
} else{
	$cats[0]->result = 1;

	$i = 0;
	foreach( $arrFlip as $id=>$cat ){
		$cats[$i]->n = (int)$id;
		$cats[$i++]->o = esc_html($cat);
	}
}

die( json_encode($cats) );


### Sort
function mergeArr($a,$b,$user=''){
	foreach($b as $ik=>$iv){
		if( $user!='' )
        	$a['-'.$user.'-'.$iv] = $ik;
		else
        	$a[$iv] = $ik;
    }
    return $a;
}
?>