<?php
if (!defined('SECRET_KEY')){ header("HTTP/1.0 404 Not Found"); exit; }

###
###  Main UI components
###

class recipeShelfUI {

	var $rS = null;
    var $boxID = 0;
	var $bg = '-blue';

	function recipeShelfUI($recipeShelfParent) {
		$this->rS = $recipeShelfParent;
		if ( array_key_exists('rS_background', $this->rS->_user_options) && $this->rS->_user_options['rS_background']['active']!='' )
			$this->bg = $this->rS->_user_options['rS_background']['active'];

	}

	function HtmlPrintBoxHeader($id, $title) {
	    ?>
        <div id="<?php echo $id; ?>" class="postbox closed">
	        <h3 id="box<?php echo $this->boxID++; ?>" class="hndle" title="<?php _e('Drag and drop to rearrange','recipeshelf'); ?>"><div class="handlediv" title="<?php _e('Click to toggle','recipeshelf'); ?>"></div><span><?php echo $title ?></span></h3>
		        <div class="inside wrapper" id="<?php echo $id; ?>-iscroll">
	    <?php
	}

	function HtmlPrintBoxFooter() {
        ?>
            </div>
        </div>
        <?php
	}

    function GetCustomOptions() {
    	$r = '';
		$username = md5($this->rS->_user_name);
		if( array_key_exists('rS_custom', $this->rS->_options) && array_key_exists($username, $this->rS->_options['rS_custom']) ){
	        if( is_array($this->rS->_options['rS_custom'][$username]) ){
		        foreach($this->rS->_options['rS_custom'][$username] as $k=>$v)
		            $r .= $k.',';
			}
		}
        return substr($r,0,-1);
    }

	function HtmlPrintCheckBoxes($set, $title) {
    	?>
        <p id="rs-p-<?php echo $set; ?>" class="options-header" >
        <label><?php echo $title; ?></label>
		<a href='javascript:void(0)' class="rs-open-img closed" id="box<?php echo $this->boxID++; ?>" title="<?php _e('Open','recipeshelf'); ?>"></a>
		<span id="<?php echo $set; ?>-used" class="options-used"><?php _e('(xxx selected)','recipeshelf'); ?></span>
        </p>
		<div id="rs-<?php echo $set; ?>-inside" class="options-inside">
        <?php
  		if( array_key_exists('rS_'.$set, $this->rS->_options) && is_array($this->rS->_options['rS_'.$set]) ){

	        if( $set == 'custom' ){

	            foreach( array_keys($this->rS->_options['rS_custom']) as $user)
		            foreach($this->rS->_options['rS_custom'][$user] as $k=>$v)
		                $aTMP[sanitize($k)] = '-'.$user.'-'.$v;


			} else {

	                foreach($this->rS->_options['rS_'.$set] as $k=>$v)
	                    $aTMP[__($k,'recipeshelf')] = $v;

	                if( $set == 'cuisine' )
		                ksort($aTMP);

            }

			if( is_array($aTMP) && count($aTMP)>0 ){
		        foreach( $aTMP as $k=>$v){
					$v = esc_html($v);
		            $imgBeauty = '<img src="'.RS_URL.'/img/checkbox-off.png" id="ic-rs-opt'.$v.'" alt="'.$k.'" title="'.$k.'" class="imageCheck"/>';
		            echo '<div class="rs-extra-items">'.$imgBeauty.'<input type="checkbox" id="rs-opt'.$v.'" name="rs-opt'.$v.'" value="'.$v.'" title="'.$set.'"/>'.
						 '<label for="rs-opt'.$v.'" class="icLabel" title="'.__('Toggle','recipeshelf').'">'.$k.'</label></div>'."\n";
		            }
			}

		}
		echo '<input type="hidden" id="rs-'.$set.'-count" class="hidden-counts" value="0"/><div class="rs-clear"></div>';
	    echo '</div>';
	}


	function HtmlPrintCheckBoxesSearch($set, $title) {
	  if( array_key_exists('rS_'.$set, $this->rS->_options) && is_array($this->rS->_options['rS_'.$set]) ){
	        ?>
	        <p id="rs-searchcat-<?php echo $set; ?>" class="rs-search-cat"><?php echo $title; ?></p>
	        <div id="rs-search-<?php echo $set; ?>-inside" class="options-inside">
	        <?php
	        if( is_array($this->rS->_options['rS_'.$set]) ){
		        if( $set == 'custom' ){

		            foreach( array_keys($this->rS->_options['rS_custom']) as $user)
			            foreach($this->rS->_options['rS_custom'][$user] as $k=>$v)
			                $aTMP[$k] = '-'.$user.'-'.$v;

				} else {

		                foreach($this->rS->_options['rS_'.$set] as $k=>$v)
		                    $aTMP[__($k,'recipeshelf')] = $v;

		                if( $set == 'cuisine' )
			                ksort($aTMP);

	            }

				if( is_array($aTMP) && count($aTMP)>0 ){
			        foreach($aTMP as $k=>$v){
			            $imgBeauty = '<img src="'.RS_URL.'/img/checkbox-off.png" id="ic-rs-search-opt'.$v.'" alt="'.$k.'" title="'.$k.'" class="imageCheck"/>';
			            echo '<div class="rs-search-adv-items">'.$imgBeauty.'<input type="checkbox" id="rs-search-opt'.$v.'" name="rs-search-opt'.$v.'" value="'.$v.'" title="'.$set.'"/>'.
							 '<label for="rs-search-opt'.$v.'" class="icLabel" title="'.__('Toggle','recipeshelf').'">'.$k.'</label></div>'."\n";
			            }
	            }

            }
	        echo '<div class="rs-clear"></div>';
	        echo '</div>';
		}
	}


	function renderBGbuttons() {

		$fileGLOB	= dirname(__FILE__).'/../img/grid-*.gif';
		$imgArr		= glob($fileGLOB);

		for($i=0;$i<count($imgArr);$i++){
		    $bg = preg_replace( '/grid(.+)\.gif/i', '$1', basename($imgArr[$i]) );
		    $active = $this->bg==$bg?' bg-active':'';
			echo '<input type="button" class="rSbutton rs-bg'.$active.'" style="background:url('.RS_URL.'/img/grid'.$bg.'.gif)" id="rs-button-bg'.$bg.'" name="rs-button-bg'.$bg.'" value=""/> ';
		}
		?>
		<input type="hidden" id="rs-bg-active" name="rs-bg-active" value="<?php echo $this->bg; ?>"/>
		<?php
	}


	### control input...
	function HtmlShowOptionsPage() {
	
	//	echo "*********** {$this->rS->_user_name}<pre>".print_r($this->rS->_options['rS_custom'][$this->rS->_user_name],1)."</pre>";
	
	    $ro = $this->rS->_readonly?'ro-disabled':'';
		?>
		<div class="wrap" id="rs-wrap">
			<div class="rs-right metabox-holder">
				<div id="sidebar-sortables" class="meta-box-sortables ui-sortable">
				<?php $this->HtmlPrintBoxHeader('rs-sidebar-image',__('Recipe Image','recipeshelf')); ?>
	            	<div id="rs-addimage">
                    	<img id="rs-img" src="<?php echo RS_URL; ?>/img/default-photo-off.jpg" alt="" title=""/>
                    </div>
            		<div id="rs-img-control">
						<?php if( !$this->rS->_readonly ) : ?>
	            			<a href="javascript:void(0);" class="rs-add" id="rs-add" title="<?php _e('Add an image','recipeshelf'); ?>"></a>
		        			<a href="javascript:void(0);" class="rs-remove" title="<?php _e('Remove image','recipeshelf'); ?>"></a>
						<?php endif; ?>
            			<a href="javascript:void(0);" class="rs-right" title="<?php _e('Next image','recipeshelf'); ?>"></a>
            			<a href="javascript:void(0);" class="rs-left" title="<?php _e('Previous image','recipeshelf'); ?>"></a>
            			<div class="rs-clear"></div>
                    </div>

                    <input disabled="disabled" type="hidden" value="<?php _e('Please save this recipe first, or load one from the archive!','recipeshelf'); ?>" id="rs-add-image-r1"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Error: invalid file extension','recipeshelf'); ?>" id="rs-add-image-r2"/>

                    <input disabled="disabled" type="hidden" value="<?php _e('Edit Recipe &nbsp;&nbsp;&nbsp; <span class=editNote>[Last edited on xxx]</span>','recipeshelf'); ?>" id="rs-text-h1"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Edit Recipe &nbsp;&nbsp;&nbsp; <span class=editNote>[Auto-saved on xxx]</span>','recipeshelf'); ?>" id="rs-text-h2"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Add a new recipe','recipeshelf'); ?>" id="rs-text-h3"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('(auto saved)','recipeshelf'); ?>" id="rs-text-h4"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Please provide a name for this recipe first!','recipeshelf'); ?>" id="rs-text-h5" name="rs-text-h5"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('No recipe information saved or loaded yet. This area will refresh after saving your recipe.','recipeshelf'); ?>" id="rs-text-h6" name="rs-text-h6"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Recipe Layout','recipeshelf'); ?>" id="rs-text-h7" name="rs-text-h7"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Remove','recipeshelf'); ?>" id="rs-text-h9" name="rs-text-h9"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('recipeShelf will now reboot.','recipeshelf'); ?>" id="rs-text-h10" name="rs-text-h10"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Drag and drop to rearrange','recipeshelf'); ?>" id="rs-text-h11" name="rs-text-h11"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Search Results','recipeshelf'); ?>" id="rs-text-h12" name="rs-text-h12"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('Item will be deleted. Continue?','recipeshelf'); ?>" id="rs-text-h13" name="rs-text-h13"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('This recipe will be deleted. Continue?','recipeshelf'); ?>" id="rs-text-del" name="rs-text-del"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('All below listed elements will be deleted. Continue ?','recipeshelf'); ?>" id="rs-text-del2" name="rs-text-del2"/>
                    <input disabled="disabled" type="hidden" value="<?php _e('This image will be deleted. Continue?','recipeshelf'); ?>" id="rs-text-del3" name="rs-text-del3"/>
				<?php $this->HtmlPrintBoxFooter(); ?>

				<?php $this->HtmlPrintBoxHeader('rs-sidebar-search',__('Search Recipe Database','recipeshelf')); ?>
					<div class="rs-dbinfo">
                    	<label for="rs-search-text" title="<?php _e('Use *, + &amp; - to fine tune your search query!','recipeshelf'); ?>"><?php _e('Search term:','recipeshelf'); ?></label>
                    	<br />
                        <div>
	                        <input type="text" id="rs-search-text" name="rs-search-text" value="*" title="<?php _e('Use *, + &amp; - to fine tune your search query!','recipeshelf'); ?>"/>
	                        <a href="javascript:void(0)" id="rs-button-search-adv" title="<?php _e('More search options...','recipeshelf'); ?>" rel="0"></a>
                        </div>
					</div>
					<div id="rs-search-adv">
	                    <?php $this->HtmlPrintCheckBoxesSearch('season',__('Season','recipeshelf')); ?>
	                    <?php $this->HtmlPrintCheckBoxesSearch('course',__('Course / Occasion','recipeshelf')); ?>
	                    <?php $this->HtmlPrintCheckBoxesSearch('cuisine',__('Cuisine','recipeshelf')); ?>
	                    <?php $this->HtmlPrintCheckBoxesSearch('type',__('Recipe Type','recipeshelf')); ?>
	                    <?php $this->HtmlPrintCheckBoxesSearch('additional',__('Additional Info','recipeshelf')); ?>
	                    <?php $this->HtmlPrintCheckBoxesSearch('diet',__('Diet','recipeshelf')); ?>
	                    <?php $this->HtmlPrintCheckBoxesSearch('custom',__('User Defined','recipeshelf')); ?>
                    </div>
				<?php $this->HtmlPrintBoxFooter(); ?>

				<?php $this->HtmlPrintBoxHeader('rs-sidebar-tags',__('Recipe Tags','recipeshelf')); ?>
				<?php $this->HtmlPrintBoxFooter(); ?>

				<?php $this->HtmlPrintBoxHeader('rs-sidebar-last',__('Recently Modified Recipes','recipeshelf')); ?>
				<?php $this->HtmlPrintBoxFooter(); ?>

				<?php $this->HtmlPrintBoxHeader('rs-sidebar-star',__('Starred Recipes','recipeshelf')); ?>
				<?php $this->HtmlPrintBoxFooter(); ?>

				<?php $this->HtmlPrintBoxHeader('rs-sidebar-all',__('All Recipes','recipeshelf')); ?>
				<?php $this->HtmlPrintBoxFooter(); ?>

				<?php $this->HtmlPrintBoxHeader('rs-sidebar-thoughts',__('Great Ideas','recipeshelf')); ?>
                	<form action="ajax/ajax-add-a-thought.php" method="post" name="rs-thought-form" id="rs-thought-form">
	                	<input type="text" id="rs-thought-text" name="rs-thought-text" value="<?php _e('Tell me','recipeshelf'); ?>" onfocus="if (this.value == '<?php _e('Tell me','recipeshelf'); ?>') {this.value = ''}" />
                    </form>
					<div id="rs-thought-list"></div>
				<?php $this->HtmlPrintBoxFooter(); ?>

				</div>
			</div>
			<div class="rs-left metabox-holder<?php if( $this->rS->_iPad ) echo ' partFrame'; ?>">
				<form method="post" action="<?php echo RS_URL . '/ajax/ajax-form.php'; ?>" id="rs-editor-form">
				<div id="normal-sortables" class="meta-box-sortables ui-sortable">

				<?php // $this->HtmlPrintBoxHeader('rs-editor',__('Add a new recipe','recipeshelf')); ?>
			<div class="postbox" id="rs-editor">
				<h3><div title="<?php _e('Toggle Search Results','recipeshelf'); ?>" class="handletoggle" id="rs-toggle-search"></div><div title="<?php _e('Toggle Favorite','recipeshelf'); ?>" class="handletoggle" id="rs-toggle-star"></div><span><?php _e('Add a new recipe','recipeshelf'); ?></span></h3>
				<div class="inside" style="display: block;">
<?php
/*
                <div id="rs-shortcuts-container">
					<ul id="rs-shortcuts">
						<li><a href="javascript:void(0)" id="rs-toggle-shortcut" title="<?php _e('Toggle Recipe Layout / Editor','recipeshelf'); ?>"></a></li>
						<li><a href="javascript:void(0)" id="rs-new-shortcut" class="<?php echo $ro ?>" title="<?php _e('New Recipe','recipeshelf'); ?>"></a></li>

						<li><a href="javascript:void(0)" id="rs-saveupdate-shortcut" class="<?php echo $ro ?>" title="<?php _e('Save Recipe','recipeshelf'); ?>"></a></li>
						<li><a href="javascript:void(0)" id="rs-clone-shortcut" class="<?php echo $ro ?>" title="<?php _e('Duplicate Recipe','recipeshelf'); ?>"></a></li>
						<li><a href="javascript:void(0)" id="rs-star-shortcut" class="off <?php echo $ro ?>" title="<?php _e('Toggle Favorite','recipeshelf'); ?>"></a></li>

						<li><a href="javascript:void(0)" id="rs-delete-shortcut" class="<?php echo $ro ?>" title="<?php _e('Delete Recipe','recipeshelf'); ?>"></a></li>
						<li><a href="javascript:void(0)" id="rs-settings-shortcut" title="<?php _e('User Settings','recipeshelf'); ?>"></a></li>
					</ul>
                </div>
*/
?>
                <div id="rs-configuration">
					<?php if( !$this->rS->_readonly ) : ?>
	                    <p>
						<label for="rs-config-custom"><?php _e('User defined <strong>Recipe Categories</strong> (comma sperated)','recipeshelf'); ?></label>
	                    <input type="text" id="rs-config-custom" name="rs-config-custom" value="<?php echo $this->GetCustomOptions(); ?>"/>
	                      <br/>
	                    <label for="rs-config-autosave"><?php _e('<strong>Auto-save</strong> time intervall (in seconds)','recipeshelf'); ?></label>
						<input type="text" id="rs-config-autosave" name="rs-config-autosave" value="<?php if( array_key_exists('rS_autosave', $this->rS->_user_options) ) echo $this->rS->_user_options[rS_autosave]; ?>"/>
	                      </p>
					<?php endif; ?>
                    <p>
						<label for="rs-config-email"><?php _e('<strong>Email address</strong> (e.g. for sending recipe emails)','recipeshelf'); ?></label>
						<input type="text" id="rs-config-email" name="rs-config-email" value="<?php echo addslashes(unsanitize($this->rS->_user_options['rS_email'],false)); ?>"/>
						<label for="rs-config-author"><?php _e('<strong>Author</strong>','recipeshelf'); ?></label>
						<input type="text" id="rs-config-author" name="rs-config-author" value="<?php echo addslashes(unsanitize($this->rS->_user_options['rS_author'],false)); ?>"/>
                    </p>
					<table class="rs-bg-buttons">
					<tr>
						<td>
							<label><?php _e('<strong>Background color</strong>','recipeshelf'); ?></label>
						</td>
						<td>
		                    <?php $this->renderBGbuttons() ?>
						</td>
        			</tr>
					</table>
                    <table>
					<tr>
						<td><label for="rs-config-pwo"><strong><?php _e('Old password','recipeshelf'); ?></strong></label></td>
						<td><input type="password" id="rs-config-pwo" name="rs-config-pwo" value=""/></td>
					</tr><tr>
						<td><label for="rs-config-pw1"><strong><?php _e('New password','recipeshelf'); ?></strong></label></td>
						<td><input type="password" id="rs-config-pw1" name="rs-config-pw1" value=""/></td>
					</tr><tr>
						<td><label for="rs-config-pw2"><strong><?php _e('Confirm new password','recipeshelf'); ?></strong></label></td>
						<td><input type="password" id="rs-config-pw2" name="rs-config-pw2" value=""/></td>
					</tr>
					</table>
                    <input type="button" value="<?php _e('Save Configuration','recipeshelf'); ?>" name="rs-button-config-save" id="rs-button-config-save" class="rSbutton"/>
                </div>

				<div id="rs-editor-edit">

				<fieldset id="rs-recipeinfo">
					<p class="sub"><?php _e('Please enter recipe name and a brief summary.','recipeshelf'); ?></p>
	                <p>
                    	<label for="rs-name"><?php _e('Name of the recipe','recipeshelf'); ?></label><br />
	                	<input type="text" id="rs-name" name="rs-name" value=""/>
                    </p>
					<p>
	                	<label for="rs-desc"><?php _e('Brief description','recipeshelf'); ?></label><br />
	                	<textarea class="wysiwygtext" cols="60" rows="6" id="rs-desc" name="rs-desc"></textarea><br />
	                	<label for="rs-tags"><?php _e('Tags','recipeshelf'); ?></label>
						<input type="text" id="rs-tags" name="rs-tags" value=""/>
                    </p>
				</fieldset>

				<fieldset id="rs-details">
					<p class="sub"><?php _e('Recipe Details','recipeshelf'); ?></p>
					<table>
					    <tr>
	                    <td><label for="rs-yield" class="rs-extra-label"><?php _e('Yield','recipeshelf'); ?></label></td>
	                    <td>
							<input type="text" id="rs-yield" name="rs-yield" />
		                    <input type="text" id="rs-yield-unit" name="rs-yield-unit" value="<?php _e('Servings','recipeshelf'); ?>"/>
					    </td>
						</tr>
					    <tr>
	                    <td><label for="rs-ctime-o" class="rs-extra-label"><?php _e('Cooking Time','recipeshelf'); ?></label></td>
						<td>
							<span class="rs-ctime-o-label"><?php _e('Overall','recipeshelf'); ?> <input type="text" id="rs-ctime-o" name="rs-ctime-o" /></span>
							<span class="rs-ctime-a-label"><?php _e('Active','recipeshelf'); ?> <input type="text" id="rs-ctime-a" name="rs-ctime-a" /></span>
							<span class="rs-ctime-p-label"><?php _e('Passive','recipeshelf'); ?> <input type="text" id="rs-ctime-p" name="rs-ctime-p" /></span>
                        </td>
					    </tr>
					    <tr>
	                    <td><label for="rs-kcal" class="rs-extra-label"><?php _e('Kcal','recipeshelf'); ?></label></td>
	                    <td>
							<input type="text" id="rs-kcal" name="rs-kcal" />
					    </td>
						</tr>
					    <tr>
	                    <td><label for="rs-level" class="rs-extra-label"><?php _e('Level','recipeshelf'); ?></label></td>
	                    <td>
							<select id="rs-level" name="rs-level">
		                        <option value="0"><?php _e('Easy','recipeshelf'); ?></option>
		                        <option value="1"><?php _e('Medium','recipeshelf'); ?></option>
		                        <option value="2"><?php _e('Difficult','recipeshelf'); ?></option>
							</select>
	                    </td>
					    </tr>
					</table>
				</fieldset>

				<fieldset id="rs-ing">
					<p class="sub subXtra"><?php _e('Add all ingredients','recipeshelf'); ?></p>
                   	<div class="rs-amount"><label for="rs-amount1"><?php _e('Amount','recipeshelf'); ?></label></div>
                    <div class="rs-unit"><label for="rs-unit1"><?php _e('Unit','recipeshelf'); ?></label></div>
                    <div class="rs-product"><label for="rs-product1"><?php _e('Ingredient','recipeshelf'); ?></label></div>
                    <div class="rs-attribute"><label for="rs-attribute1"><?php _e('Info','recipeshelf'); ?></label></div>
					<div id="rs-ingredients" class="ui-sortable">
						<div id="rs-i1" class="rs-ingredients-item">
	                        <div class="rs-amount"><input type="text" id="rs-amount1" name="rs-amount1" class="regular-text" value=""/></div>
	                        <div class="rs-unit"><input type="text" id="rs-unit1" name="rs-unit1" class="regular-text" value=""/></div>
	                        <div class="rs-product"><input type="text" id="rs-product1" name="rs-product1" class="regular-text" value=""/></div>
	                        <div class="rs-attribute"><input type="text" id="rs-attribute1" name="rs-attribute1" class="regular-text" value=""/></div>
	                        <div class="hndle-ing" title="<?php _e('Drag and drop to rearrange','recipeshelf'); ?>"></div>
                            <a href="javascript:void(0)" class="rs-item-remove" title="<?php _e('Remove','recipeshelf'); ?>"></a>
						</div>
					</div>
                    <div class="rs-add-ingredient">
                    	<input type="submit" id="rs-button-ingredient" name="rs-add-ingredient" class="rSbutton rSbutton-highlighted" value="<?php _e('Add An Ingredient','recipeshelf'); ?>"/>
                    	<input type="submit" id="rs-button-space" name="rs-add-space" class="rSbutton rSbutton-highlighted" value="<?php _e('Add Space','recipeshelf'); ?>"/>
                    </div>
					<input type="hidden" value="1" id="rs-ingredients-count" name="rs-ingredients-count"/>
				</fieldset>

				<fieldset id="rs-steps">
					<p class="sub subXtra"><?php _e('Recipe Steps','recipeshelf'); ?></p>
					<div id="rs-steps-box" class="ui-sortable">
	                    <div id="rs-step1" class="rs-steps-item">
	                    	<textarea  class="wysiwygtext" cols="60" rows="6" id="step1" name="step1"></textarea>
                        </div>
					</div>
				</fieldset>

				<fieldset id="rs-notes">
					<p class="sub subXtra"><?php _e('Personal Notes, Pitfalls, Shopping Tips, Serving Ideas etc....','recipeshelf'); ?></p>
					<div id="rs-notes-box" class="ui-sortable">
	                    <div id="rs-note1" class="rs-notes-item">
	                        <textarea  class="wysiwygtext" cols="60" rows="6" id="note1" name="note1"></textarea>
                        </div>
					</div>
				</fieldset>

				<fieldset id="rs-extra">
					<p class="sub"><?php _e('Recipe Categories','recipeshelf'); ?></p>
                    <?php $this->HtmlPrintCheckBoxes('season',__('Season','recipeshelf')); ?>
					<?php $this->HtmlPrintCheckBoxes('course',__('Course / Occasion','recipeshelf')); ?>
					<?php $this->HtmlPrintCheckBoxes('cuisine',__('Cuisine','recipeshelf')); ?>
					<?php $this->HtmlPrintCheckBoxes('type',__('Recipe Type','recipeshelf')); ?>
					<?php $this->HtmlPrintCheckBoxes('diet',__('Diet','recipeshelf')); ?>
					<?php $this->HtmlPrintCheckBoxes('additional',__('Additional Info','recipeshelf')); ?>
					<?php $this->HtmlPrintCheckBoxes('custom',__('User Defined','recipeshelf')); ?>
				</fieldset>


				<fieldset id="rs-cookedfor">
					<p class="sub subXtra"><?php _e('Recipe cooked for...','recipeshelf'); ?></p>
					<div id="rs-cookedfor-box" class="ui-sortable">
	                    <div id="rs-cf1" class="rs-cf-item">
	                        <input type="text" id="date1" name="date1" class="date-pick"/>
	                        <input type="text" id="cook1" name="cook1" class="rs-cook" />
						</div>
					</div>
	                <div class="rs-add-cookedfor">
						<input type="submit" id="rs-button-cookedfor" name="rs-add-cookedfor" class="rSbutton rSbutton-highlighted" value="<?php _e('Add Another Date','recipeshelf'); ?>"/>
					</div>
					<input type="hidden" value="1" id="rs-cookedfor-count" name="rs-cookedfor-count"/>
				</fieldset>


				<fieldset id="rs-refs">
                    <p class="sub subXtra"><?php _e('Recipe References (URLs / Book Titles etc.)','recipeshelf'); ?></p>
					<div id="rs-refs-box" class="ui-sortable">
	                    <div id="rs-ref1" class="rs-ref-item">
	                        <input type="text" id="url1" name="url1" class="rs-urls" />
						</div>
					</div>
	                <div class="rs-add-extra"><input type="submit" id="rs-button-extra" name="rs-add-extra" class="rSbutton rSbutton-highlighted" value="<?php _e('Add A Link / Book Title','recipeshelf'); ?>"/></div>
					<input type="hidden" value="1" id="rs-refs-count" name="rs-refs-count"/>
				</fieldset>

				<input type="hidden" value="0" id="rs-recipe-id" name="rs-recipe-id"/>
				<input type="hidden" value="0" id="rs-lastEdited" name="rs-lastEdited"/>


                </div><!--rs-editor-edit-->


				<div id="rs-editor-layout">
                    <div id="layout-action">
                    	<input type="button" value="<?php _e('-','recipeshelf'); ?>" name="rs-button-shrink" id="rs-button-shrink" class="rSbutton" />
                    	<input type="button" value="<?php _e('+','recipeshelf'); ?>" name="rs-button-enlarge" id="rs-button-enlarge" class="rSbutton" />
                    	<input type="button" value="<?php _e('Print Recipe','recipeshelf'); ?>" name="rs-button-print" id="rs-button-print" class="rSbutton" />
                    	<input type="button" value="<?php _e('Email Recipe','recipeshelf'); ?>" name="rs-button-email" id="rs-button-email" class="rSbutton" />
                    	<input type="button" value="<?php _e('Toggle Google Format','recipeshelf'); ?>" name="rs-button-google" id="rs-button-google" class="rSbutton" />
	                    <div id="rs-action-status">
                        </div>
	                    <div id="rs-email-config">
	                        <label for="rs-email-to"><?php _e('To','recipeshelf'); ?></label><input type="text" id="rs-email-to" name="rs-email-to" /><br />
	                        <label for="rs-email-subject"><?php _e('Subject','recipeshelf'); ?></label><input type="text" id="rs-email-subject" name="rs-email-subject" /><br />
	                        <label for="rs-email-text"><?php _e('Personal Message','recipeshelf'); ?></label><textarea class="wysiwygemail" cols="20" rows="6" id="rs-email-text" name="rs-email-text"></textarea><br />
	                    	<input type="button" value="<?php _e('Send','recipeshelf'); ?>" name="rs-button-email-send" id="rs-button-email-send" class="rSbutton" />
                        </div>
                    </div>
                	<div id="google"><div class="rsl-layout">
						<p><span class="info"><?php _e('Ok, now just copy & paste.','recipeshelf'); ?></span>
							<input type="button" value="<?php _e('Select All','recipeshelf'); ?>" name="rs-button-select" id="rs-button-select" class="rSbutton" />
							<input type="button" value="<?php _e("Add 'Hide' Style",'recipeshelf'); ?>" name="rs-button-hide" id="rs-button-hide" class="rSbutton" />
						</p>
						<textarea id="hRecipe" name="hRecipe"></textarea>
					</div></div>
                	<div id="layout"></div>
                	<div id="layout-clone"></div>
                </div>

   				<div id="rs-editor-search">
   				    <input type="button" class="rSbutton" id="rs-back" name="rs-back" value="<?php _e('Back','recipeshelf'); ?>">
					<div id="rs-search-results"></div>
                </div>

				<?php $this->HtmlPrintBoxFooter(); ?>

				</div><!--normal-sortables-->
				</form>
			</div>
		<div class="clearfix"></div>
		</div>
		<div id="popupinfo"></div>
		<?php
	}
}