<?php
if (!defined('SECRET_KEY')){ header("HTTP/1.0 404 Not Found"); exit; }

class recipeShelf {

	var $_version = '1.4.3'; // check also lib-recipe-core-class.php, lib-db-class.php, lib-iphone-class.php

	var $_options 		= array();
	var $_user_options	= array();
	var $_initiated		= false;

	var $_ui			= null;
	var $_iPad			= false;

    var	$_user_name		= '';
	var $_logged_in		= false;
	var $_readonly		= false;

	var $arrLang		= array();
	var $arrLangPos		= array();

	function recipeShelf(){
		global $rSdb;
		
		### Set Main URL
		if( !defined( 'RS_URL' ) )		
        	define( 'RS_URL', curPageURL() );

		### PHP Init Stuff
        $mem = abs(intval(@ini_get('memory_limit')));
        if($mem && $mem < 32)
            @ini_set('memory_limit', '32M');

        $time = abs(intval(@ini_get("max_execution_time")));
        if($time != 0 && $time < 120)
            @set_time_limit(120);

		### Check User Login Status
		global $user;
		$this->_user_name = $user->_user_name;
		$this->_logged_in = $user->_logged_in;
		$this->_readonly = $user->_readonly;
		$this->_iPad = $user->_iPad;

		### Init & Load User Settings
		if( !$this->_initiated && $this->_logged_in && !$rSdb->_version_check ) {
			$this->LoadOptions();
			$this->_initiated = true;
		}
		

		### Get all supp languages
		$tmp = file( dirname(__FILE__).'/../locale/lang.txt' );
		foreach( $tmp as $l ){
		    $lang = explode(' ',$l);
		    $this->arrLang[$lang[0]] = rtrim($lang[1],"\n");
			$this->arrLangPos[$lang[0]] = (int)($lang[2]);
		}

	}



	function header() {
		if ( is_array($this->_user_options['rS_background']) && $this->_user_options['rS_background']['active']!='' )
			$this->bg = $this->_user_options['rS_background']['active'];
		else
		    $this->bg = '-blue';

		$browser	= $_SERVER["HTTP_USER_AGENT"];
        if (preg_match("/version\/(?P<majorVersion>\d*)(?P<minorVersion>(?:\.\d*)*)/i",$browser, $matches)) {
            $broversion = $matches["majorVersion"].$matches["minorVersion"];
        }
        else {
            $broversion = 'unknown';
        }
		###echo $broversion;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
<head profile="http://gmpg.org/xfn/11">
	<title>recipeShelf</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="cache-control" content="no-cache" />
	<meta name="robots" content="noindex" />
	<link rel="shortcut icon" href="<?php echo RS_URL; ?>/img/favicon.ico" />
	<link rel="apple-touch-icon" href="<?php echo RS_URL; ?>/img/apple-touch-icon.png" />
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/css/recipeshelf.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/js/CLEditor/jquery.cleditor.css" type="text/css" media="screen" />
<?php if( isset($browser) && strpos($browser, "Safari") > -1 ) : ?>
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/css/recipeshelf-safari.css" type="text/css" media="screen" />
<?php endif; ?>
<?php if( isset($browser) && strpos($browser, "MSIE") > -1 ) : ?>
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/css/recipeshelf-ie8.css" type="text/css" media="screen" />
<?php endif; ?>
<?php if( isset($browser) && strpos($browser, "Opera") > -1 && version_compare($broversion, '10.51')<0 ) : ?>
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/css/recipeshelf-opera.css" type="text/css" media="screen" />
<?php endif; ?>

<?php if( isset($browser) && strpos($browser, "iPad") > -1 ) : ?>
	<meta name="viewport" content="width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;"/>
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<meta name="apple-mobile-web-app-status-bar-style" content="black" />
	<link rel="apple-touch-icon" href="<?php echo RS_URL; ?>/img/apple-touch-icon190.png" />
	<link rel="apple-touch-startup-image" href="<?php echo RS_URL; ?>/img/startupPortrait.png" media="screen and (orientation: portrait)"/>
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/css/recipeshelf-iPad.css" type="text/css" media="screen" />
<?php endif; ?>

	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/jquery.js"></script>
<?php if( isset($browser) && !strpos($browser, "iPad") ) : ?>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/CLEditor/jquery.cleditor.min.js"></script>
<?php endif; ?>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/recipeshelf-library.min.js"></script>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/recipeshelf.min.js"></script>
<?php if( isset($browser) && strpos($browser, "iPad") > -1 ) : ?>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/iscroll-min.js"></script>
<?php endif; ?>
	<script type="text/javascript">
		var _ajax_nonce_newpasswd='_ajax_nonce=<?php echo rS_create_nonce( 'newpasswd' ); ?>';
		var _ajax_nonce_logout='<?php echo rS_create_nonce( 'logout' ); ?>';
		var _ajax_nonce_messageboard='<?php echo rS_create_nonce( 'messageboard' ); ?>';
		var _ajax_nonce_remove_element='<?php echo rS_create_nonce( 'remove-element' ); ?>';
		var	_ajax_nonce_get_item={'user':'<?php echo rS_create_nonce( 'get-user' ); ?>', 'info':'<?php echo rS_create_nonce( 'get-info' ); ?>', 'email':'<?php echo rS_create_nonce( 'get-email' ); ?>', 'unit':'<?php echo rS_create_nonce( 'get-unit' ); ?>','user':'<?php echo rS_create_nonce( 'get-user' ); ?>','ing':'<?php echo rS_create_nonce( 'get-ing' ); ?>'};
		var _ajax_nonce_get_ingredient='<?php echo rS_create_nonce( 'auto-ingredient' ); ?>';
		var _ajax_nonce_get_attribute='<?php echo rS_create_nonce( 'auto-attribute' ); ?>';
		var _ajax_nonce_get_unit='<?php echo rS_create_nonce( 'auto-unit' ); ?>';
		var _ajax_nonce_get_email='<?php echo rS_create_nonce( 'auto-email' ); ?>';
		var _ajax_nonce_image_upload='<?php echo rS_create_nonce( 'image-upload' ); ?>';
		var _ajax_nonce_remove_image='<?php echo rS_create_nonce( 'image-remove' ); ?>';
		var _ajax_nonce_send_email='<?php echo rS_create_nonce( 'send-email' ); ?>';
		var _ajax_nonce_custom_options='<?php echo rS_create_nonce( 'custom-options' ); ?>';
		var _ajax_nonce_importexport='<?php echo rS_create_nonce( 'import-export' ); ?>';
		var _ajax_nonce_dbinfo='<?php echo rS_create_nonce( 'dbinfo' ); ?>';
		var _ajax_nonce_delete_recipe='<?php echo rS_create_nonce( 'delete-recipe' ); ?>';
		var _ajax_nonce_layout_recipe='<?php echo rS_create_nonce( 'layout-recipe' ); ?>';
		var _ajax_nonce_star_recipe='<?php echo rS_create_nonce( 'star-recipe' ); ?>';
		var _ajax_nonce_load_recipe='<?php echo rS_create_nonce( 'load-recipe' ); ?>';
		var _ajax_nonce_get_tags='<?php echo rS_create_nonce( 'get-tags' ); ?>';
		var _ajax_nonce_search='<?php echo rS_create_nonce( 'search' ); ?>';
		var _ajax_add_thought='<?php echo rS_create_nonce( 'add-thought' ); ?>';
		var _ajax_last_recipes='<?php echo rS_create_nonce( 'last-recipes' ); ?>';
		var _ajax_get_starred='<?php echo rS_create_nonce( 'get-starred' ); ?>';
		var _ajax_list_thought='<?php echo rS_create_nonce( 'list-thought' ); ?>';
		var _ajax_remember_img='<?php echo rS_create_nonce( 'remember-image' ); ?>';
		var _ajax_nonce_download='<?php echo rS_create_nonce( 'download' ); ?>';
		var _ajax_nonce_backup_restore='<?php echo rS_create_nonce( 'backup-restore' ); ?>';
		var _ajax_nonce_save_recipe='<?php echo rS_create_nonce( 'save-recipe' ); ?>';
		
		jQuery.dpText = {
			TEXT_PREV_YEAR		:	'<?php echo htmlentities( __('Previous year','recipeshelf'),ENT_QUOTES, "UTF-8" ); ?>',
			TEXT_PREV_MONTH		:	'<?php echo htmlentities( __('Previous month','recipeshelf'),ENT_QUOTES, "UTF-8" ); ?>',
			TEXT_NEXT_YEAR		:	'<?php echo htmlentities( __('Next year','recipeshelf'),ENT_QUOTES, "UTF-8" ); ?>',
			TEXT_NEXT_MONTH		:	'<?php echo htmlentities( __('Next month','recipeshelf'),ENT_QUOTES, "UTF-8" ); ?>',
			TEXT_CLOSE			:	'<?php echo htmlentities( __('Close','recipeshelf'),ENT_QUOTES, "UTF-8" ); ?>',
			TEXT_CHOOSE_DATE	:	'<?php echo htmlentities( __('Choose date','recipeshelf'),ENT_QUOTES, "UTF-8" ); ?>',
			HEADER_FORMAT		:	'mmmm yyyy'
		}
		Date.dayNames   = ['<?php echo htmlentities( __('Sunday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('Monday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('Tuesday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('Wednesday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('Thursday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('Friday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('Saturday','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>'];
		Date.monthNames	= ['<?php echo htmlentities( __('January','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('February','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('March','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('April','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('May','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('June','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('July','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('August','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('September','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('October','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('November','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>', '<?php echo htmlentities( __('December','recipeshelf'), ENT_QUOTES, "UTF-8" ); ?>'];
		Date.format = '<?php _e('mm/dd/yyyy','recipeshelf'); ?>';
	</script>
</head>
<body<?php if( $this->_logged_in ) echo ' style="background-image:url('.RS_URL.'/img/grid'.$this->bg.'.gif)"'; ?><?php if( $this->_readonly ) echo ' class="ro"'; ?>>
<?php
	}


	function footer($wall=true) {
?>
<input disabled="disabled" type="hidden" value="<?php echo RS_URL; ?>" id="rsurl"/>
<input disabled="disabled" type="hidden" value="<?php _e('For recipeShelf to properly function, please turn on browser cookies.','recipeshelf'); ?>" id="rs-text-h8" name="rs-text-h8"/>
<div id="screen"></div>
<div id="footer">
	<div class="alignleft" id="footer-left">
		<span id="poweredby">Powered by </span><a href="http://www.deliciousdays.com/">deliciousdays.com</a>/<a href="http://www.deliciousdays.com/recipeshelf">recipeShelf</a>.
		<?php if($wall): ?><a id="messageboard" href="javascript:void(0)"><?php _e('Message Board','recipeshelf');?></a><?php endif; ?>
	</div>
	<div class="alignright" id="footer-version"><strong>Version <?php echo $this->_version ?></strong></div>
	<div class="clear"></div>
</div>
</body>
</html>
<?php
	}

	function language() {
	?>
	<div id="language" class="modalWin">
	    <h1 class="title"><?php _e('Languages','recipeshelf');?></h1>
		<select id="langsel" name="sellang">
<?php
    	$y = 0;
		foreach( $this->arrLang as $set=>$l ){
			if ( !array_key_exists('rSlang', $_COOKIE) )
				$lang = 'en_US';
			else
				$lang = $_COOKIE['rSlang'];
				
		    $sel = ( $set==$lang )?' selected="selected"':'';
			$y = -($this->arrLangPos[$set] * 26);
		    echo '<option value="'.$set.'" style="background-position:0 '.$y.'px" '.$sel.'>'.$l.'</option>';
		}
?>
		</select>
		<div class="admin-return">
			<a href="javascript:void(0)" class="rSbutton" onclick="javascript:langOK();"><?php _e('Switch Language','recipeshelf');?></a>
			<a href="javascript:void(0)" class="rSbutton cancelWin" <?php echo (! $this->_iPad)?'onclick':'ontouchend' ?>="javascript:winCancel();"><?php _e('Cancel','recipeshelf');?></a>
		</div>
	</div>
	<?php
	}


	function help() {
	?>
	<div id="help" class="modalWin">
	    <h1 class="title"><?php _e('Keyboard Shortcuts','recipeshelf');?></h1>
	    <table>
			<tr><th class="sc"><?php _e('Shortcut','recipeshelf');?></th><th><?php _e('Function','recipeshelf');?></th></tr>
			<tr><td class="sc">CTRL + <span>S</span></td><td><?php _e('Save / update recipe','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>N</span></td><td><?php _e('New recipe','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>F</span></td><td><?php _e('Open "Search" sidebar module');?></td></tr>
			<tr><td class="sc">CTRL + <span>&crarr;</span></td><td><?php _e('Add a row (depending on context)','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>T</span></td><td><?php _e('Toggle editor / Recipe Layout','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>I</span></td><td><?php _e('Open "Ideas" sidebar module','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>P</span></td><td><?php _e('Print recipe','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>M</span></td><td><?php _e('Email recipe','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>U</span></td><td><?php _e('User settings','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>A</span></td><td><?php _e('Admin screen','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>L</span></td><td><?php _e('Switch language','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>B</span></td><td><?php _e('Message board','recipeshelf');?></td></tr>
			<tr><td class="sc">CTRL + <span>H</span></td><td><?php _e('This help page','recipeshelf');?></td></tr>
	    </table>
		<div class="admin-return">
			<a href="javascript:void(0)" class="rSbutton cancelWin" <?php echo (! $this->_iPad)?'onclick':'ontouchend' ?>="javascript:winCancel();"><?php _e('Return','recipeshelf');?></a>
		</div>
	</div>
	<?php
	}


	function msgboard() {
	?>
	<div id="msgboard" class="modalWin">
	    <h1 class="title"><?php _e('Message Board','recipeshelf');?></h1>
	    <div id="msgboard-update">
		</div>
		<div class="admin-return">
			<a href="javascript:void(0)" class="rSbutton cancelWin" <?php echo (! $this->_iPad)?'onclick':'ontouchend' ?>="javascript:winCancel();"><?php _e('Return','recipeshelf');?></a>
		</div>
	</div>
	<?php
	}



	function admin() {
	?>
	<div id="admin" class="modalWin">

	    <h1 class="title"><?php _e('Administration','recipeshelf');?></h1>
		<div id="admin-tabs">
		    <ul class="tabNav">
		        <li><a href="#fragment-1"><span><?php _e('Units','recipeshelf');?></span></a></li>
		        <li><a href="#fragment-2"><span><?php _e('Ingredients','recipeshelf');?></span></a></li>
		        <li><a href="#fragment-3"><span><?php _e('Additional Info','recipeshelf');?></span></a></li>
		        <li><a href="#fragment-4"><span><?php _e('Email Addresses','recipeshelf');?></span></a></li>
		        <li><a href="#fragment-5"><span><?php _e('Additional Users','recipeshelf');?></span></a></li>
		        <li><a href="#fragment-6"><span><?php _e('Backup &amp; Restore','recipeshelf');?></span></a></li>
		        <li><a href="#fragment-7"><span><?php _e('Import &amp; Export','recipeshelf');?></span></a></li>
		    </ul>
		    <div class="tabContainer">
			    <div id="fragment-1" class="tab">
					<div class="admin-search">
						<input type="text" id="admin-search-unit" name="admin-search-unit" value="" title=""/>
						<a href="javascript:void(0)" class="admin-search-button rSbutton-small" id="da3"><?php _e('Search','recipeshelf');?></a>
						<a href="javascript:void(0)" class="admin-delete-all rSbutton-small"><?php _e('Delete All','recipeshelf');?></a>
					</div>
					<div id="admin-unit-results" class="admin-res"></div>
			    </div>
			    <div id="fragment-2" class="tab">
				<div class="admin-search">
					<input type="text" id="admin-search-ing" name="admin-search-ing" value="" title=""/>
						<a href="javascript:void(0)" class="admin-search-button rSbutton-small" id="da1"><?php _e('Search','recipeshelf');?></a>
					<a href="javascript:void(0)" class="admin-delete-all rSbutton-small"><?php _e('Delete All','recipeshelf');?></a>
				</div>
				<div id="admin-ing-results" class="admin-res"></div>
			    </div>
			    <div id="fragment-3" class="tab">
					<div class="admin-search">
						<input type="text" id="admin-search-info" name="admin-search-info" value="" title=""/>
						<a href="javascript:void(0)" class="admin-search-button rSbutton-small" id="da2"><?php _e('Search','recipeshelf');?></a>
						<a href="javascript:void(0)" class="admin-delete-all rSbutton-small"><?php _e('Delete All','recipeshelf');?></a>
					</div>
					<div id="admin-info-results" class="admin-res"></div>
			    </div>
			    <div id="fragment-4" class="tab">
					<div class="admin-search">
						<input type="text" id="admin-search-email" name="admin-search-email" value="" title=""/>
						<a href="javascript:void(0)" class="admin-search-button rSbutton-small" id="da4"><?php _e('Search','recipeshelf');?></a>
						<a href="javascript:void(0)" class="admin-delete-all rSbutton-small"><?php _e('Delete All','recipeshelf');?></a>
					</div>
					<div id="admin-email-results" class="admin-res"></div>
			    </div>
			    <div id="fragment-5" class="tab">
					<div class="admin-search">
						<input type="text" id="admin-search-user" name="admin-search-user" value="" title=""/>
						<a href="javascript:void(0)" class="admin-search-button rSbutton-small" id="da6"><?php _e('Search','recipeshelf');?></a>
						<a href="javascript:void(0)" class="admin-delete-all rSbutton-small"><?php _e('Delete All','recipeshelf');?></a>
					</div>
					<div id="admin-user-results" class="admin-res"></div>
					<div class="admin-user">
						<h2 class="title"><?php _e('New Read-Only User','recipeshelf');?></h2>
						<span id="admin-user-details">
	   						<label for="admin-new-user"><?php _e('Username','recipeshelf');?></label>
							<input type="text" id="admin-new-user" name="admin-new-user" value="" title=""/>
	   						<label for="admin-new-user-pw"><?php _e('Email Address','recipeshelf');?></label>
							<input type="text" id="admin-new-user-pw" name="admin-new-user-pw" value="" title=""/>
							<a href="javascript:void(0)" class="rSbutton-small" id="admin-new-user-add"><?php _e('Add User','recipeshelf');?></a>
						</span>
					</div>
			    </div>
			    <div id="fragment-6" class="tab">
					<div class="rs-dbinfo"><strong><?php _e('Database Information','recipeshelf'); ?></strong></div>
                    <div id="admin-imex-results"></div>
					<a href="javascript:void(0)" class="rSbutton" id="admin-full-backup"><?php _e('Backup to file','recipeshelf');?></a>
					<img class="imageCheck" title="" alt="" id="ic-rs-adm1000" src="<?php echo RS_URL; ?>/img/checkbox-off.png" />
					<label for="rs-adm1000" class="icLabel"><?php _e('Enable ZIP compression','recipeshelf');?></label>
					<input type="checkbox" id="rs-adm1000" name="admin-zip" value="zip" title="" />
					<a href="javascript:void(0)" class="rSbutton" id="admin-full-restore"><?php _e('Restore from file','recipeshelf');?></a>
					<br />
					<span id="admin-res"></span>
			    </div>
			    <div id="fragment-7" class="tab">
                        <div class="rs-dbinfo"><strong><?php _e('recipeShelf XML Import & Export','recipeshelf'); ?></strong></div>
						<?php if( !$this->_readonly ) : ?>
		                    <input type="button" value="<?php _e('Export Current Recipe','recipeshelf'); ?>" name="rs-button-export" id="rs-button-export" class="rSbutton" />
		                    <input type="button" value="<?php _e('Export All Recipes','recipeshelf'); ?>" name="rs-button-export-all" id="rs-button-export-all" class="rSbutton" />
		                    <input type="button" value="<?php _e('Import Recipe(s)','recipeshelf'); ?>" name="rs-button-import" id="rs-button-import" class="rSbutton" />
						<?php endif; ?>
			    </div>
			</div>
		</div>

		<div class="admin-return">
			<a href="javascript:void(0)" class="rSbutton cancelWin" <?php echo (! $this->_iPad)?'onclick':'ontouchend' ?>="javascript:winCancel();"><?php _e('Return','recipeshelf');?></a>
		</div>
	</div>
	<?php
	}


	function login() {
	global $user;
	$stat = $this->_logged_in?'login-ok':'login-err';
	?>
	<div id="login" class="centerWin" <?php if($this->_logged_in) echo 'style="display:none"'; ?>>
		<div class="title"><?php _e('LOGIN','recipeshelf');?></div>
		<div id="status" class="<?php echo $stat; ?>"><?php if( defined('LTDVERSION') ) echo 'Use demo/demo for login/passwd!<br/>'; echo $user->_status; ?></div>
		<form name="login-form" id="login-form" action="index.php" method="post">
			<?php rS_nonce_field( 'std_login_page' ); ?>
			<label><?php _e('Login','recipeshelf');?> </label><br /><input type="text" id="user-l" name="user" class="user" value="" /><br />
			<label><?php _e('Password','recipeshelf');?> </label><br /><input type="password" name="pass" class="pass" value="" />
			<p class="alignright">
				<input type="submit" id="login-button" name="login-button" class="rSbutton" value="<?php _e('Login','recipeshelf');?>" />
			</p>
			<input type="hidden" name="sublogin-std-alone" id="sublogin-std-alone" value="1" />
			<input type="hidden" name="remember" id="remember" value="1" />
			<input type="hidden" name="redirect_to" value="/"/>
		</form>
		<form name="reset-pw" id="reset-pw" action="index.php" method="post">
			<?php rS_nonce_field( 'pwreset_page' ); ?>
			<input type="submit" title="" name="pw" value="<?php _e('Lost your password?','recipeshelf');?>"/>
		</form>
	</div>
	<?php
	}

	function rightClickMenu() {
		$ro = $this->_readonly?'ro-disabled':'';
?>
	<div class="contextMenu" id="jqContextMenu"><ul>
		<li id="rsContext-search"><?php _e('Toggle Search Results','recipeshelf'); ?></li>
		<li id="rsContext-toggle"><?php _e('Toggle Recipe Layout / Editor','recipeshelf'); ?></li>
		<li class="shortcut-break-top jqContextDisabled"></li>
		<li class="shortcut-break-bottom jqContextDisabled"></li>
		<li id="rsContext-saveupdate" class="<?php echo $ro ?>"><?php _e('Save Recipe','recipeshelf'); ?></li>
		<li id="rsContext-star" class="off <?php echo $ro ?>"><?php _e('Toggle Favorite','recipeshelf'); ?></li>
		<li class="shortcut-break-top jqContextDisabled"></li>
		<li class="shortcut-break-bottom jqContextDisabled"></li>
		<li id="rsContext-new" class="<?php echo $ro ?>"><?php _e('New Recipe','recipeshelf'); ?></li>
		<li id="rsContext-clone" class="<?php echo $ro ?>"><?php _e('Duplicate Recipe','recipeshelf'); ?></li>
		<li id="rsContext-delete" class="<?php echo $ro ?>"><?php _e('Delete Recipe','recipeshelf'); ?></li>
		<li class="shortcut-break-top jqContextDisabled"></li>
		<li class="shortcut-break-bottom jqContextDisabled"></li>
		<li id="rsContext-settings"><?php _e('Toggle User Settings','recipeshelf'); ?></li>
	</ul></div>	
<?php
	}

	function forgotPW() {
	?>
	<div id="forgot-pw" class="centerWin">
		<div class="title"><?php _e('Lost & Found','recipeshelf');?></div>
		<div id="status"></div>
		<form name="forgot-pw-form" id="forgot-pw-form" action="ajax/ajax-forgot-pw.php" method="post">
			<?php rS_nonce_field( 'requestpassword' ); ?>		
			<label><?php _e('Please provide your username','recipeshelf');?> </label><br /><input type="text" id="user-l" name="user" class="user" value="" /><br />
			<input type="submit" id="forgot-pw-button" name="forgot-pw-button" class="rSbutton" value="<?php _e('Reset & Email Password','recipeshelf');?>" />
		</form>
	</div>
	<?php
	}

	
	function headerBar() {
	?>
	<div id="headerbar">
	    <div id="headerbar-title">
	        <a href="javascript:void(0)"><img id="logo" src="<?php echo curPageURL() ?>/img/logo.png" alt="recipeShelf" /></a>
	    </div>
	</div>
	<?php
	}


    function dropFade() {
		$pos = 2;
		if ( array_key_exists('rSlang', $_COOKIE) )
			$pos = -($this->arrLangPos[$_COOKIE['rSlang']] * 20) + 2;
		else
			$pos = -($this->arrLangPos['en_US'] * 20) + 2;		
    ?>
	<div id="drop-fade" class="sub-on">

   		<?php $enabled = $this->_logged_in?'':' disabled'; ?>
		<a id="logoutlink" class="<?php echo $enabled?>" href="javascript:void(0)"><?php _e('Logout','recipeshelf'); ?></a>
		<span id="menuhelper"><?php _e('Menu','recipeshelf'); ?></span>
		<a id="langlink" class="menulink" href="javascript:void(0)" style="background-position:0 <?php echo $pos; ?>px"><?php _e('Language','recipeshelf'); ?></a>
		<a id="adminlink" class="menulink<?php echo $enabled; ?>" href="javascript:void(0)"><?php _e('Admin','recipeshelf'); ?></a>
		<a id="helplink" class="menulink" href="javascript:void(0)"><?php _e('Help','recipeshelf'); ?></a>

	</div>
	<?php
	}


	function LoadOptions() {

        if( !isset($rSdb) )
        	global $rSdb;

		$this->InitOptions();

		$this->_user_options = $rSdb->get_option( $this->_user_name."_options");

		$storedoptions = $rSdb->get_option("recipeShelf_options");

		if($storedoptions && is_array($storedoptions)) {
		
			foreach($storedoptions AS $k=>$v)
				$this->_options[$k]=$v;

		} else
			$rSdb->update_option("recipeShelf_options",$this->_options);

	}


	function InitOptions() {
	    $this->_options = array();
	    $this->_options["rS_autosave"] = 150;
        $this->_options["rS_exportName"] = "recipe.xml";
	    $this->_options["rS_season"] = array( 'spring' => 1001,
	                                          'summer' => 1002,
	                                          'autumn' => 1003,
	                                          'winter' => 1004,
	                                          'year round' => 1005,
	                                          'holiday' => 1006
	      );
	    $this->_options["rS_course"] = array( 'appetizer' => 2001,
	                                          'entr&eacute;e' => 2002,
	                                          'main course' => 2003,
	                                          'side' => 2004,
	                                          'dessert' => 2005,
	                                          'breakfast' => 2006,
	                                          'snack' => 2007,
	                                          'picnic' => 2008,
	                                          'teatime' => 2009,
	                                          'bbq' => 2010,
	                                          'partyfood' => 2011,
	                                          'preserve' => 2012,
	                                          'gift' => 2013,
	                                          'drink' => 2014
	      );
	    $this->_options["rS_cuisine"] = array('african' => 3001,
	                                          'asian' => 3002,
	                                          'australian' => 3003,
	                                          'austrian' => 3004,
	                                          'bavarian' => 3005,
	                                          'british' => 3006,
	                                          'caribbean' => 3007,
	                                          'chinese' => 3008,
	                                          'cajun/creole' => 3009,
	                                          'eastern european' => 3010,
	                                          'french' => 3011,
	                                          'fusion' => 3012,
	                                          'german' => 3013,
	                                          'greek' => 3014,
	                                          'indian' => 3015,
	                                          'irish' => 3016,
	                                          'italian' => 3017,
	                                          'japanese' => 3018,
	                                          'jewish' => 3019,
	                                          'mediterranean' => 3020,
	                                          'mexican' => 3021,
	                                          'middle eastern' => 3022,
	                                          'portuguese' => 3023,
	                                          'scandinavian' => 3024,
	                                          'south american' => 3025,
	                                          'spanish' => 3026,
	                                          'swiss' => 3027,
	                                          'thai' => 3028,
	                                          'turkish' => 3029,
	                                          'vietnamese' => 3030,
	                                          'usa' => 301,
	                                          'other' => 3032
	      );
	    $this->_options["rS_type"] = array(   'nibble &amp; antipasto' => 4001,
	                                          'soup &amp; stew' => 4002,
	                                          'salad &amp; dressing' => 4003,
	                                          'pasta' => 4004,
	                                          'risotto' => 4005,
	                                          'rice &amp; grain' => 4006,
	                                          'potato' => 4007,
	                                          'cheese' => 4008,
	                                          'egg' => 4009,
	                                          'vegetable' => 4010,
	                                          'pork' => 4011,
	                                          'beef' => 4012,
	                                          'lamb' => 4013,
	                                          'veal' => 4014,
	                                          'game' => 4015,
	                                          'potato' => 4016,
	                                          'chicken' => 4017,
	                                          'duck' => 4018,
	                                          'goose' => 4019,
	                                          'fish' => 4020,
	                                          'seafood' => 4021,
	                                          'sauce &amp; salsa' => 4022,
	                                          'dip &amp; spread' => 4023,
	                                          'spice mix' => 4024,
	                                          'sweet preserve' => 4025,
	                                          'savory preserve' => 4026,
	                                          'pizza' => 4027,
	                                          'quiche' => 4028,
	                                          'bread' => 4029,
	                                          'bread roll' => 4030,
	                                          'cracker' => 4031,
	                                          'sandwich' => 4032,
	                                          'cake' => 4033,
	                                          'tart &amp; pie' => 4034,
	                                          'sweet pastry' => 4035,
	                                          'muffin &amp; cupcake' => 4036,
	                                          'cookie &amp; bar' => 4037,
	                                          'pancake &amp; waffle' => 4038,
	                                          'granola' => 4039,
	                                          'ice cream &amp; sorbet' => 4040,
	                                          'confection of pastry' => 4041,
	                                          'dairy dessert' => 4042,
	                                          'fruit' => 4043,
	                                          'truffle &amp; candy' => 4044,
	                                          'beverage' => 4045
	      );
	    $this->_options["rS_additional"] = array('budget' => 5001,
	                                          'classic' => 5002,
	                                          'fast food' => 5003,
	                                          'fancy' => 5004,
	                                          'for kids' => 5005,
	                                          'keeps well' => 5006,
	                                          'make ahead' => 5007,
	                                          'one dish' => 5008,
	                                          'quick' => 5009,
	                                          'simple' => 5010,
	                                          'spicy' => 5011,
	                                          'takes time' => 5012
	      );
	    $this->_options["rS_diet"] = array(   'gluten-free' => 6001,
	                                          'glyx' => 6002,
	                                          'low-carb' => 6003,
	                                          'low-fat' => 6004,
	                                          'raw' => 6005,
	                                          'vegan' => 6006,
	                                          'vegetarian' => 6007,
	                                          'vitamin-packed' => 6008,
	                                          'whole food' => 6009
	        );

  	}


	function HtmlShowOptionsPage() {

		$ui = $this->GetUI();

		if($ui) {
			$ui->HtmlShowOptionsPage();
			return true;
		}

		return false;
	}


	function Enable() {
		if(!isset($GLOBALS["rS_instance"])) {
			$GLOBALS["rS_instance"]=new recipeShelf();
		}
	}

	function &GetInstance() {
		if(isset($GLOBALS["rS_instance"])) {
			return $GLOBALS["rS_instance"];
		} else return null;
	}

	function GetUI() {

		if($this->_ui === null) {

			$className='recipeShelfUI';
			$fileName='lib-recipe-ui-class.php';

			if(!class_exists($className)) {

				$path = trailingslashit(dirname(__FILE__));

				if(!file_exists( $path . $fileName)) return false;
				require_once($path. $fileName);

			}
			$this->_ui = new $className($this);
		}

		return $this->_ui;
	}


}