<?php
if (!defined('SECRET_KEY')){ header("HTTP/1.0 404 Not Found"); exit; }

###
###  Basic Layout Class
###

class recipeLayout {

	var $_n = "\n";
	var $_options;
	var $id;
    var $pluginURL;
    var $fileURL;
	var $arrIMGs;
	var $arrSteps;
	var $arrNotes;
	var $arrCookinT;
    var $arrYield;
    var $arrCookedFor;
	var $arrURLs;

	var $arrOptions;
	var $recipe;

	var $css = array();

	function recipeLayout( $id, $pluginURL='', $css=false ){
	    global $rSdb;

	    $this->id			= $id;
	    
	    if( $pluginURL!='' ){
		    $this->pluginURL	= $pluginURL;
		    $this->fileURL    	= $pluginURL . '/photos/';
		}

	    $this->arrIMGs  	= glob(  dirname(__FILE__).'/../photos/'.$id.'_*.*'  );
		if( is_array($this->arrIMGs) )
			  usort($this->arrIMGs,"sort_by_mtime");
		
		//$id					= (int)$_POST['recipe-id'];
		$sql				= "SELECT * FROM {$rSdb->DBrecipes} WHERE id='".esc_sql($id)."'";

	    $this->recipe		= $rSdb->fetchArr($sql);
	    $this->recipe		= $this->recipe[0];

	    $this->arrSteps 	= explode('$%&',$this->recipe->steps);
	    $this->arrStepsOld 	= strpos($this->recipe->steps,'$%&')!==false ? true:false;

	    $this->arrNotes 	= explode('$%&',$this->recipe->notes);
	    $this->arrNotesOld 	= strpos($this->recipe->notes,'$%&')!==false ? true:false;

	    $this->arrCookinT	= explode('$$$',$this->recipe->cookingtime);
	    $this->arrYield		= explode('$$$',$this->recipe->yield);

		if ( strlen($this->recipe->options) > 0)
	    	$this->arrOptions	= explode('$%&',$this->recipe->options);

	    $this->arrCookedFor	= explode('$%&',$this->recipe->cooked);
	    $this->arrURLs		= explode('$%&',$this->recipe->urls);

	    $this->_options		= $rSdb->get_option("recipeShelf_options");

		if( $css )
        	$this->css		= file ( $css  );
	}


    function addCSS(){
	    $r = '';
        foreach ($this->css as $i)
	        $r .= $i;
        return $r;
    }
	function addPhoto($p){
    	$p = $p - 1;
		$r = '';

	    if ( isset($this->arrIMGs[$p]) && $this->arrIMGs[$p]<>'' )
            $r .= '<img id="rsl-photo0" src="'.esc_html($this->fileURL.basename($this->arrIMGs[$p])).'"/>';
		else if ( isset($this->arrIMGs[0]) && $this->arrIMGs[0]<>'' )
            $r .= '<img id="rsl-photo0" src="'.esc_html($this->fileURL.basename($this->arrIMGs[0])).'"/>';

        return $r;
	}
	function addName(){
        return esc_html($this->recipe->name);
	}
	function addDescription(){
        return _rem_script($this->recipe->description); ###contains HTML! can't escape
	}
	function mergeArr($a,$b,$user=''){
    	foreach($b as $ik=>$iv){
			if( $user!='' )
            	$a['-'.$user.'-'.$iv] = $ik;
			else
            	$a[$iv] = $ik;
        }
        return $a;
	}
	function addCats(){
		$arrFlip  = array_flip( $this->_options["rS_season"] );
		$arrFlip  = $this->mergeArr( $arrFlip, $this->_options["rS_course"] );
		$arrFlip  = $this->mergeArr( $arrFlip, $this->_options["rS_cuisine"] );
		$arrFlip  = $this->mergeArr( $arrFlip, $this->_options["rS_type"] );
		$arrFlip  = $this->mergeArr( $arrFlip, $this->_options["rS_additional"] );
		$arrFlip  = $this->mergeArr( $arrFlip, $this->_options["rS_diet"] );

		if( array_key_exists('rS_custom', $this->_options) && is_array($this->_options["rS_custom"]) && count($this->_options["rS_custom"])>0)
			foreach( array_keys($this->_options["rS_custom"]) as $user ){
            	$arrFlip  = $this->mergeArr( $arrFlip, $this->_options["rS_custom"][$user],$user );
                }

		$r = '';
        for($j=0;$j<count($this->arrOptions);$j++){
            $r .= '<span>'.__( $arrFlip[$this->arrOptions[$j]] ,'recipeshelf').'</span>, ';
		}
		
		// Add user tags
		if( strlen( $this->recipe->tags ) > 1  ){
			$tagArr = explode(',',$this->recipe->tags);
			foreach( $tagArr as $tag ){
				if( $tag != '' )
					$r .= '<span>'.esc_html($tag).'</span>, ';
			}
		}
		
        return substr($r,0,-2);
	}
	function addSteps(){
		$r = '';
        for($j=0;$j<count($this->arrSteps);$j++){
			if ($j>0 && $this->arrStepsOld)
	            $r .= '<p class="rsl-step-sep"></p>' . $this->_n;

			if ( $this->arrStepsOld )	$r .= '<p class="rsl-step'.($j+1).'">';
			    
			$r .= _rem_script($this->arrSteps[$j]); ### contains HTML

			if ( $this->arrStepsOld )	$r .= '</p>' . $this->_n;
        }
        return $r;
	}
	function addNotes(){
		$r = '';
        for($j=0;$j<count($this->arrNotes);$j++){
			if ($j>0 && $this->arrNotesOld)
	            $r .= '<p class="rsl-note-sep"></p>' . $this->_n;

			if ( $this->arrNotesOld )	$r .= '<p class="rsl-note'.($j+1).'">';

            $r .= _rem_script($this->arrNotes[$j]); ### contains HTML

			if ( $this->arrNotesOld )	$r .= '</p>' . $this->_n;
		}
        return $r;
	}
	function addCookedFor(){
		$r = '';
        for($j=0;$j<count($this->arrCookedFor);$j++){
			$item = explode('$$$',$this->arrCookedFor[$j]);
            $r .= '<p class="rsl-cooked-for'.($j+1).'">'.esc_html($item[1]).' - '.esc_html($item[0]).'</p>' . $this->_n;
        }
        return $r;
	}
	function addURLs(){
		$r = '';
        for($j=0;$j<count($this->arrURLs);$j++)
            $r .= '<p class="rsl-urls'.($j+1).'">'.esc_html($this->arrURLs[$j]).'</p>' . $this->_n;
        return $r;
	}
	function addYield(){
        return esc_html($this->arrYield[0]).' '.esc_html($this->arrYield[1]);
	}
	function addKcal(){
        return esc_html($this->arrYield[2]);
	}
	function addCookingTime($time){
    	switch( $time ){
			case 'active': return esc_html($this->arrCookinT[0]); break;
			case 'passive': return esc_html($this->arrCookinT[1]); break;
			case 'overall': return esc_html($this->arrCookinT[2]); break;
            default: break;
        }
	}
	function addIngredients(){
	    $r = $this->_n . '<table class="rsl-ing-items">' . $this->_n;
	    if ( $this->recipe->ingredients<>'' ){
	        $iArr = explode('$%&',$this->recipe->ingredients);
	        for($j=0;$j<count($iArr);$j++){
	            $itemArr = explode('$$$',$iArr[$j]);
                if( strpos($itemArr[0],'spacer') !== false ){
	                $r .= '<tr>' . $this->_n;
	                $r .= '<td colspan="2" class="rsl-spacer">---</td>' . $this->_n;
	                $r .= '</tr>' . $this->_n;
                }else{
	                $r .= '<tr>' . $this->_n;
	                $r .= '<td class="rsl-amount">'.esc_html($itemArr[0]).'&nbsp;'.esc_html($itemArr[1]).'</td>' . $this->_n;
	                $r .= '<td class="rsl-product"><span class="rsl-product-name">'.esc_html($itemArr[2]).'</span> <span class="rsl-product-desc">'.esc_html($itemArr[3]).'</span></td>' . $this->_n;
	                $r .= '</tr>' . $this->_n;
                }
	        }
	    }
	    $r .= '</table>' . $this->_n;
        return $r;
	}

}

?>