<?php
if (!defined('SECRET_KEY')){ header("HTTP/1.0 404 Not Found"); exit; }

###
### iphone LAYOUT class
###

class renderLayout {

	var $_version = '1.4.3'; // check also lib-recipe-core-class.php, lib-db-class.php, lib-iphone-class.php

	var $applemobile;
    var $desired_view;
	var $recipe_css;
	var $_logged_in;
	var $_user_options;
	var $bg;

	var $arrLang = array();

	function renderLayout( $recipetheme ) {

       	global $rSdb, $user;

    	$this->applemobile	= detectAppleMobile();
        $this->recipe_css	= file( dirname(__FILE__) . '/../iphone/core-css/'.$recipetheme  );

		if($user->_logged_in){
			$this->_logged_in = $user->_logged_in;
			$this->_user_options = $rSdb->get_option( $user->_user_name."_options" );
			$this->bg = $this->_user_options["rS_background"]['active'];
		}

		if( !defined(RS_URL) )		
        	define( 'RS_URL', curPageURL() );

		### Get all supp languages
		$tmp = file( dirname(__FILE__).'/../locale/lang.txt' );
		foreach( $tmp as $l ){
		    $lang = explode(' ',$l);
		    $this->arrLang[$lang[0]]['name'] = $lang[1];
		    $this->arrLang[$lang[0]]['pos'] = $lang[2];
		}
    }


    function addRecipeCSS(){
	    $r = '';
        foreach ($this->recipe_css as $i)
	        $r .= "\t".$i;
        echo $r;
    }


	function header() {

	$iphone = $this->applemobile?'iphone':'';
	
	?>
<!DOCTYPE html>
<html manifest="TMPmanifest.php">
<head>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<META HTTP-EQUIV="Pragma-directive" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Directive" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="0">
	<meta charset="UTF-8" />
	<title>recipeShelf</title>
	<link rel="stylesheet" href="<?php echo RS_URL; ?>/core-css/iphone.css" type="text/css"/>
	<link rel="shortcut icon" href="/img/favicon.ico" type="image/x-icon">
  	<style type="text/css" media="screen">@import "<?php echo RS_URL; ?>/core-css/iqtouch.css";</style>
	<style type="text/css" media="screen">@import "<?php echo RS_URL; ?>/core-css/iphone.css";</style>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/jquery.1.4.1.min.js" charset="utf-8"></script>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/jqtouch.min.js" type="application/x-javascript" charset="utf-8"></script>
	<script type="text/javascript" src="<?php echo RS_URL; ?>/js/iphone.min.js"  charset="utf-8"></script>
	<style>
	<?php $this->addRecipeCSS(); ?>
	</style>
	<script type="text/javascript">
		var _ajax_nonce_i_rem_thought='<?php echo rS_create_nonce( 'remove-thought' ); ?>';
		var _ajax_nonce_i_search='<?php echo rS_create_nonce( 'search' ); ?>';
		var _ajax_nonce_i_list_thoughts='<?php echo rS_create_nonce( 'list-thoughts' ); ?>';
		var _ajax_nonce_i_add_thoughts='<?php echo rS_create_nonce( 'add-thoughts' ); ?>';
		var _ajax_nonce_i_login='<?php echo rS_create_nonce( 'login' ); ?>';
		var _ajax_nonce_i_logout='<?php echo rS_create_nonce( 'logout' ); ?>';
		var _ajax_nonce_i_layout='<?php echo rS_create_nonce( 'layout' ); ?>';
		var _ajax_nonce_i_email='<?php echo rS_create_nonce( 'send-email' ); ?>';
		var _ajax_nonce_i_data='<?php echo rS_create_nonce( 'get-data' ); ?>';
		var _ajax_nonce_i_cats='<?php echo rS_create_nonce( 'get-cats' ); ?>';
	</script>	
	<?php echo $this->_logged_in ? '<script type="text/javascript" charset="utf-8">var logged_in = true;</script>' : ''; ?>
</head>
<body class="<?php echo $iphone; ?>">
	<div id="manifestloader"><?php _e('Caching...','recipeshelf'); ?></div>
	<?php
	}


	function footer() {
		echo '</body></html>';
	}


	function text_dummies() {
	?>
	<input type="hidden" id="notoniphone" value="<?php _e('You\'re not viewing this page from your iPhone!','recipeshelf'); ?>"/>
	<input type="hidden" id="emailtext6" value="<?php _e('Are you sure?','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-err" value="<?php _e('Offline mode not supported on your device!','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-err2" value="<?php _e('Please synchronize first!','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-ok" value="<?php _e('recipeShelf can now be used offline.','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-search" value="<?php _e('No recipes found!','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-wait" value="<?php _e('Syncing now...','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Active" value="<?php _e('Active','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Passive" value="<?php _e('Passive','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Overall" value="<?php _e('Overall','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Yield" value="<?php _e('Yield','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Kcal" value="<?php _e('Kcal','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Steps" value="<?php _e('Steps','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-Notes" value="<?php _e('Notes','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-CFor" value="<?php _e('Cooked for','recipeshelf'); ?>"/>
	<input type="hidden" id="offlinetext-URLS" value="<?php _e('References','recipeshelf'); ?>"/>
	<?php
	}


	function toolbar() {
		return	'<div class="toolbar">'.
				'<a href="javascript:void(0);" class="back">'.__('Back','recipeshelf').'</a>'.
				'</div>';
	}


	function page($id, $c) {
 	?>
	<div id="<?php echo $id; ?>">
		<?php echo $this->toolbar(); ?>
		<?php echo $c; ?>
	</div>
	<?php
	}


	function page_main() {
	 	global $rSdb;
	    // Get User Background
		if ($this->bg == '')
		    $this->bg = '-blue';

		if ( file_exists( dirname(__FILE__) . '/../iphone/core-img/grid-iphone'.$this->bg.'.gif' ) )
			$path = '/core-img/grid-iphone';
		else
			$path = '/../img/grid';

 	?>
	<div id="main" class="current" style="background:url(<?php echo RS_URL . $path . $this->bg; ?>.gif)">
		<div class="toolbar-main">
			<?php echo $this->headerBar(); ?>
			<?php echo $this->dropFade(); ?>
		</div>
		<div id="screen"></div>
		<div id="search-results"></div>
		<?php $this->text_dummies(); ?>
	</div>
	<?php
	}


	function page_images() {
 	?>
	<div id="recipe-images">
		<div id="img-container"></div>
		<div id="img-control"><a href="javascript:void(0);" id="img-next"><?php _e('Next','recipeshelf') ?></a><a href="javascript:void(0);" id="img-close"><?php _e('Close','recipeshelf') ?></a></div>
	</div>
	<?php
	}


	function page_about() {
 	?>
	<div id="about">
		<?php echo $this->toolbar(); ?>
		<p>Powered by <a href="http://www.deliciousdays.com/">recipeShelf v<?php echo $this->_version?></a><br/>
		<a href="http://www.deliciousdays.com/">deliciousdays.com</a></p>
	</div>
	<?php
	}


	function page_emailform() {
 	?>
	<div id="email-form">
		<?php echo $this->toolbar(); ?>
		<div class="status"></div>
		<div id="email-box">
			<form action="../ajax/ajax-send-email.php" method="post">
			<h2><?php _e('EMAIL RECIPE','recipeshelf') ?></h2>
			<ul class="edit rounded">
				<li class="relative"><input placeholder="<?php _e('To','recipeshelf') ?>" type="text" id="email-to" name="email-to" /><a href="#select-emails" id="abook" class="cube"></a></li>
				<li><input placeholder="<?php _e('Subject','recipeshelf') ?>" type="text" name="email-subject" id="email-subject"/></li>
				<li><textarea placeholder="<?php _e('Personal Message','recipeshelf') ?>" rows="8" name="email-text" id="email-text"></textarea></li>
			</ul>
			<p><input type="button" id="email-submit" title="" value="<?php echo __(Send,recipeshelf)?>"/></p>
			</form>
		</div>
	</div>
	<?php
	}


	
	function page_add_thought() {
 	?>
	<div id="add-ideas">
		<?php echo $this->toolbar(); ?>
		<form id="add-ideas-form" action="ajax/ajax-add-a-thought.php" method="post">
	        <h2><?php _e('ADD AN IDEA','recipeshelf') ?></h2>
			<ul class="edit rounded">
				<li><input placeholder="<?php _e('I\'m all ears...','recipeshelf') ?>"type="text" id="thought-text" name="thought-text" value=""/></li>
			</ul>
			<div class="status"></div>
			<input type="hidden" name="submit-thought" value="1"/>
		</form>
        <h2><?php _e('REMOVE AN IDEA','recipeshelf') ?></h2>
        <div id="add-ideas-results"></div>
	</div>
	<?php
	}



	function page_login() {
	?>
	<div id="login">
		<?php echo $this->toolbar(); ?>
		<form name="login-form" id="login-form" action="ajax/ajax-login.php" method="post">
			<h2><?php _e('LOGIN','recipeshelf') ?></h2>
			<ul class="edit rounded">
			<li><input placeholder="<?php _e('Username','recipeshelf') ?>" type="text" id="user-l" name="user" class="user" value="" /></li>
			<li><input placeholder="<?php _e('Password','recipeshelf') ?>" type="password" id="pass-l" name="pass" class="pass" value="" /></li>
			</ul>
			<input type="hidden" name="iphonelogin" value="Login" tabindex="9" id="iphonelogin" />
			<input type="hidden" name="remember" id="remember" value="1">
		</form>
		<div class="status"></div>
	</div>
	<?php
	}
	

	function getAllLanguages() {
		$res = '<ul class="edgetoedge">';
        $res .= '<li class="sep">'.__('Languages','recipeshelf').'</li>';

    	$yOff = 45;
		foreach( $this->arrLang as $set=>$l ){
			$y = $yOff + ( -($l['pos']+1) * 35);
        	$res .=  '<li><a class="return" href="javascript:void(0);" title="'.$set.'" style="background-position:8px '.$y.'px">'.$l['name'].'</a></li>';
		}
		return $res.'</ul>';
	}
	
	
	function headerBar() {
		$enabled = $this->_logged_in?'':' disabled';

		return	'<div id="headerbar">'.
	    			'<div id="headerbar-menu"><a href="#select-menu" class="dissolve'.$enabled.'"></a></div>'.
				'</div>';
	}


    function menuActions() {
   		$pos = 10;
		if( $_COOKIE['rSlang']<>'' ){
		
			### debug
			### echo "pos=".$this->arrLang[$_COOKIE['rSlang']]['pos'];
			
			//$seq = ( array_flip(array_keys($this->arrLang)) );
			if( is_array( $this->arrLang[$_COOKIE['rSlang']] ) )
				$pos = -(($this->arrLang[$_COOKIE['rSlang']]['pos']+1) * 35) + 47;
		}

	return ''.
		'<div class="status"></div>'.
		'<div id="search">'.
			'<form method="post" id="search-form" action="ajax/ajax-search.php">'.
			        '<h2>'.__('SEARCH','recipeshelf').'</h2>'.
					'<ul class="edit rounded">'.
						'<li><input placeholder="'.__('Search','recipeshelf').'" type="text" value="*" name="search-text" id="search-text" /></li>'.
					'</ul>'.
					'<input name="button-search" type="hidden" tabindex="5" value="Search"/>'.
				'</form>'.
		'</div>'.
        '<div id="menu">'.
			'<ul class="edit rounded">'.
				'<li class="forward"><a id="synclink" href="javascript:void(0);">'.__('Sync for offline use','recipeshelf').'</a></li>'.
				'<li class="forward"><a id="listthoughtlink" class="cube" href="#list-ideas">'.__('List all ideas','recipeshelf').'</a></li>'.
				'<li class="forward"><a id="addthoughtlink" class="cube" href="#add-ideas">'.__('Add / Remove an idea','recipeshelf').'</a></li>'.
				'<li class="forward"><a id="languagelink" class="cube" href="#select-lang" style="background-position:8px '.$pos.'px">'.__('Change the language','recipeshelf').'</a></li>'.
				'<li class="forward"><a id="logoutlink" href="javascript:void(0);">'.__('Logout','recipeshelf').'</a></li>'.
			'</ul>'.
        '</div>';
	}


    function dropFade() {
		global $rSdb;
		if ( !$rSdb->InstallCheck() )
			return;

   		$en1 = $this->_logged_in?'display:none':'';
		$en2 = $this->_logged_in?'':' display:none';

		return	'<div class="status info"></div><div id="drop-fade" class="sub-on">'.
				'<span id="set1" style="'.$en1.'"><a id="loginopen" class="fade" href="#login">'.__( 'Login' ).'</a></span>'.
				'<span id="set2" style="'.$en2.'">'.
				'<a id="allopen" class="forceSlide" href="#select-all">'.__('Recent','recipeshelf').'</a>'.
				'<a id="a-zopen" class="forceSlide" href="#select-a-z">'.__('A-Z','recipeshelf').'</a>'.
				'<a id="staropen" href="javascript:void(0);">'.__('Starred','recipeshelf').'</a>'.
				'<a id="tagsopen" class="forceSlide" href="#select-tags">'.__('Tags','recipeshelf').'</a>'.
				'</span></div>';
	}

}
?>