<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('search', false) )
	die(__('Security Alert: Direct access not permitted!','recipeshelf'));

if( isset($_POST['tag']) ){

	$sql = "SELECT id,description,name FROM {$rSdb->DBrecipes} WHERE tags LIKE '%".esc_sql((string)_rem_magic_quote($_POST['tag']))."%' ORDER BY date_added LIMIT 0,100";
	$recipes = $rSdb->fetchArr($sql);

}else{
	$q = (string)_rem_magic_quote( $_POST['q']);
	$o = (string)_rem_magic_quote( $_POST['o']);
		
	$o = stripslashes($o) . ' ';

	if( $q=='*' ){
    
		$sql = "SELECT id,description,name FROM {$rSdb->DBrecipes} WHERE 1 ".$o."LIMIT 0,100";
		$recipes = $rSdb->fetchArr($sql);
    
	}else{

		if( strpos('*', $q)===false )
			$qq = '*'.$q.'*';
	
		### try with MATCH AGAINST first 
		$m = "MATCH(name,description,tags,ingredients) AGAINST('".esc_sql($qq)."' IN BOOLEAN MODE) ";
		$sql = "SELECT id,description,name FROM {$rSdb->DBrecipes} WHERE ".$m.$o."LIMIT 0,100";
		$recipes = $rSdb->fetchArr($sql);

		if ($recipes===false){
			### then normal if failed
			$qq = esc_sql( str_replace('*','',$q) );
			$m = "name LIKE '%".$qq."%' OR description LIKE '%".$qq."%' OR tags LIKE '%".$qq."%' OR ingredients LIKE '%".$qq."%'";	
			$sql = "SELECT id,description,name FROM {$rSdb->DBrecipes} WHERE ".$m.$o."LIMIT 0,100";
			$recipes = $rSdb->fetchArr($sql);
		}
		
	}

	
}

/*
$sql = "SELECT *, ".
	   "( (1.3*(MATCH(tags,name) AGAINST ('{$_POST['q']}' IN BOOLEAN MODE))) + (0.6*(MATCH(description,ingredients) AGAINST ('{$_POST['q']}' IN BOOLEAN MODE))) ) AS relevance ".
	   "FROM [table_name] ".
       "WHERE ( MATCH(title,text) AGAINST ('+term +term2' IN BOOLEAN MODE) ) HAVING relevance > 0 ORDER BY relevance DESC LIMIT 0,30";
*/


//echo '<p class="rs-dbinfo"><label>'.__('Search Results:','recipeshelf').'</label><ul>';

echo '<ul>';
if( count($recipes)==0 ){

	    echo '<li>'.__('No recipes found!','recipeshelf').'</li>';

}else{

	$useroptions	= $rSdb->get_option( $user->_user_name."_options" );
	$favesArr		= is_array($useroptions['rS_favorites']) ? $useroptions['rS_favorites'] : array();

	foreach( $recipes as $r ){
	
	    $t = (strlen($r->name)<42)?$r->name:substr($r->name,0,41).'...';
		
		### remove tags from desc
		$d = stripTags( $r->description );
	    $d = (strlen($d)<121) ? $d : substr( $d ,0,120).'...';
		
		

		### Get all images
		$arrIMGs = glob(  dirname(__FILE__).'/../photos/'.$r->id.'_*.*'  );
		if( is_array($arrIMGs) )
			usort($arrIMGs,"sort_by_mtime");

		### default image?
		if( is_array($useroptions['rS_default_img']) && array_key_exists ( $r->id,$useroptions['rS_default_img'] ) && $useroptions['rS_default_img'][$r->id]>0 )
			$def_img = $useroptions['rS_default_img'][$r->id]-1;
		else
		    $def_img = 0;

       	$i		= 0;
       	$photos = array();
        if ( is_array($arrIMGs) && count($arrIMGs) > 0 ){
	        foreach( $arrIMGs as $img ){
				$photos[$i++]->src = '/photos/'.basename($img);
	        }
	        $img = '</span><span class="rs-search-img"><img src="'.esc_html((string)_rem_magic_quote($_POST['pluginURL'])).$photos[$def_img]->src.'" alt=""/>';
        }else
			$img = '</span><span class="rs-search-noimg">?';
		
		

		$s = (in_array($r->id, $favesArr)) ? '<span class="rs-search-fave" title="'.__('Favorite Recipe','recipeshelf').'"></span>':'<span class="rs-search-nonfave"></span>';

		
	    echo '<li value="'.$r->id.'"><a href="#"><span class="rs-search-title">'.($t).''.$img.'</span><span class="rs-search-desc">'.($d).'</span></a>'.$s.'</li>';

	}
}
echo '</ul>';
?>