<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
require_once('../JSON/jsonwrapper_inner.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('load-recipe', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

### Images
$id			= (int)$_POST['recipe-id'];
$fileGLOB	= dirname(__FILE__).'/../photos/'.$id.'_*.*';

$imgArr		= array();
$imgArr		= glob($fileGLOB);

$images		= '';
if( is_array($imgArr) && !empty($imgArr) ){
	usort($imgArr,"sort_by_mtime");
	for($i=0;$i<count($imgArr);$i++)
		$images .= basename($imgArr[$i]).',';
}

### Recipe Data

$recipe = $rSdb->fetchArr(	"SELECT id,date_added,DATE_FORMAT(date_added,'%Y-%m-%d') as PTdate,name,description,tags,tips,steps,notes,ingredients,yield,cookingtime,level,servewith,rating,options,cooked,urls ".
		  					"FROM {$rSdb->DBrecipes} WHERE id='".esc_sql($id)."'");

### Fix HTML enabled fields
$recipe[0]->description = _rem_script($recipe[0]->description);
$recipe[0]->steps = _rem_script($recipe[0]->steps);
$recipe[0]->notes = _rem_script($recipe[0]->notes);


### fix favorite tag
$useroptions = $rSdb->get_option( $user->_user_name."_options" );

### add rating
if ( is_array($useroptions['rS_favorites']) && in_array( $id, $useroptions['rS_favorites'] ) )
	$recipe[0]->rating = 1;
else
	$recipe[0]->rating = 0;

### default image?
if( is_array($useroptions['rS_default_img']) && array_key_exists ( $id,$useroptions['rS_default_img'] ) )
	$recipe[0]->def_img = $useroptions['rS_default_img'][$id];

### add images
$recipe[1] = $images;

### wrap up
echo json_encode($recipe);
?>