<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('image-upload', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

$uploaddir	= dirname(__FILE__).'/../photos/';
$uploadfile = $uploaddir . (int)$_POST["recipe-id"] . '_' . basename($_FILES['imageupload']['name']);

if ($_FILES) {
	foreach ($_FILES as $f) {
			// get actual image type
			$ext = strtolower(str_replace("image/", "", image_type_to_mime_type(exif_imagetype($f['tmp_name']))));
			// get image type from file extension
			$ext_file = strtolower(str_replace("image/", "", $f['type']));
			// adjustment for IE mime types
			$ext_adjust = array("pjpeg" => "jpeg", "x-png" => "png");
			$ext_file = (array_key_exists($ext_file, $ext_adjust)) ? $ext_adjust[$ext_file] : $ext_file;

			// check if file actual and ext file types match
			if ( ($ext_file != $ext) )  {
				$pst = array("problem" => array("name" =>$f['name'], "ext" => $ext, "ext_actual" => $ext_file));
				echo "err: ext";
			}
			else {
				$stat = stat($f['tmp_name']);
				$f['_upload'] = $uploadfile;
				chmod($f['tmp_name'], 0755);
				$moved = move_uploaded_file($f['tmp_name'], $f['_upload']);
				chmod($uploadfile, 0640);

				if( function_exists('getimagesize') ) :
	                $image = new SimpleImage();
	                $image->load($f['_upload']);
	                $image->resizeToWidth(250);
	                $image->save($f['_upload']);
				endif;

				if($moved)
                	echo '/photos/'.(int)$_POST["recipe-id"] . '_' . basename($_FILES['imageupload']['name']);
                else
					echo 'err: move';

			}
	}
}




###
###  IMAGE RESIZE CLASS
###


class SimpleImage {

   var $image;
   var $image_type;

   function load($filename) {
      $image_info = getimagesize($filename);
      $this->image_type = $image_info[2];
      if( $this->image_type == IMAGETYPE_JPEG ) {
         $this->image = imagecreatefromjpeg($filename);
      } elseif( $this->image_type == IMAGETYPE_GIF ) {
         $this->image = imagecreategif($filename);
      } elseif( $this->image_type == IMAGETYPE_PNG ) {
         $this->image = imagecreatefrompng($filename);
      }
   }
   function save($filename, $image_type=IMAGETYPE_JPEG, $compression=75, $permissions=null) {
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image,$filename,$compression);
      } elseif( $image_type == IMAGETYPE_GIF ) {
         imagegif($this->image,$filename);
      } elseif( $image_type == IMAGETYPE_PNG ) {
         imagepng($this->image,$filename);
      }
      if( $permissions != null) {
         chmod($filename,$permissions);
      }
   }
   function output($image_type=IMAGETYPE_JPEG) {
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image);
      } elseif( $image_type == IMAGETYPE_GIF ) {
         imagegif($this->image);
      } elseif( $image_type == IMAGETYPE_PNG ) {
         imagepng($this->image);
      }
   }
   function getWidth() {
      return imagesx($this->image);
   }
   function getHeight() {
      return imagesy($this->image);
   }
   function resizeToWidth($width) {
      if( $width >= $this->getWidth() )	return;
      $ratio = $width / $this->getWidth();
      $height = $this->getheight() * $ratio;
      $this->resize($width,$height);
   }
   function resize($width,$height) {
      $new_image = imagecreatetruecolor($width, $height);
      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
      $this->image = $new_image;
   }
}

?>