<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
require_once('../JSON/jsonwrapper_inner.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('get-tags', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

$recipes = $rSdb->fetchArr("SELECT tags FROM {$rSdb->DBrecipes}");

if ( count($recipes)==0 )
	$recipes[0]->tags = __('No tags yet.','recipeshelf');

$allT = array();
$tmpT = array();
foreach( $recipes as $r ){

    $tmpT = explode(',',$r->tags);
    foreach( $tmpT as $t ){
	    if ( !array_key_exists($t, $allT) )
    		$allT[$t] = 0;
    	$allT[$t]++;
    }
}


$countFreq = array();
$arrJSON = array();

$arrJSON[0][min]	= 0;
$arrJSON[0][max]	= 0;
$arrJSON[0][count]	= 0;

$min     = 1000;
$max     = 0;
$i=1;
foreach( $allT as $t=>$v ){

	$min = $min>$v ? $v : $min;
	$max = $max<$v ? $v : $max;

	$arrJSON[$i][tag]	= esc_html($t);
	$arrJSON[$i][freq]	= $v;
	
	$countFreq[$v]++;
    $i++;
}

$arrJSON[0][min]	= $min;
$arrJSON[0][max]	= $max;
$arrJSON[0][count]	= count( $countFreq );

echo json_encode($arrJSON);
?>