<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('get-starred', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

### Grab Options
$useroptions	= $rSdb->get_option( $user->_user_name."_options" );
$favesArr 		= $useroptions['rS_favorites'];

if ( !is_array($favesArr) || count($favesArr)==0 )
	die( '<ul><li>'.__('No marked recipes yet.','recipeshelf').'</li></ul>' );



$faves = '';
foreach( $favesArr as $f )
    $faves .= "'".$f."',";
$faves      = rtrim($faves,',');

$sql		= "SELECT id,name FROM {$rSdb->DBrecipes} WHERE id IN ({$faves})";
$recipes	= $rSdb->fetchArr($sql);


echo '<ul>';
foreach( $recipes as $r ){
	$t = (strlen($r->name)<40)?$r->name:substr($r->name,0,39).'...';
    echo '<li value="'.$r->id.'"><a href="#">'.esc_html($t).'</a></li>';
}
echo '</ul>';

?>