<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();
if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('last-recipes', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

if( $_POST['action']=='recent' )
	$sort = 'ORDER BY date_added DESC LIMIT 0,10';
else
	$sort = 'ORDER BY name';


$recipes = $rSdb->fetchArr("SELECT id, name FROM {$rSdb->DBrecipes} {$sort}");

if ( count($recipes)==0 )
	die( '<ul><li>'.__('No recipes available yet.','recipeshelf').'</li></ul>' );

echo '<ul>';
foreach( $recipes as $r ){
	$t = (strlen($r->name)<40)?$r->name:substr($r->name,0,39).'...';
    echo '<li value="'.$r->id.'"><a href="#">'.esc_html($t).'</a></li>';
}
echo '</ul>';

?>