<?php
/* Include Files ***************************/
require_once('../db-config.php');
require_once('../inc/lib-compat-class.php');
require_once('../inc/lib-db-class.php');
require_once('../inc/lib-login-class.php');
/*******************************************/
global $rSdb;

$user	= new userManagement();

if(  !$user->_logged_in  )
	die(__('Access denied.','recipeshelf'));

if( ! check_ajax_referer('custom-options', false) )
	die('0|'.__('Security Alert: Direct access not permitted!','recipeshelf'));

$storedoptions = $rSdb->get_option( "recipeShelf_options" );
$useroptions   = $rSdb->get_option( $user->_user_name."_options" );


if( is_array($storedoptions['rS_custom']) && $storedoptions['rS_custom'][$user->_user_name] )
	unset($storedoptions['rS_custom'][$user->_user_name]);

$getCats		= explode(',', sanitize($_POST['custom'],true,true ) ); //sanitze incl. magic q. check

$userCat		= array();
$newItems		= '';


### user categories
if( $_POST['custom']<>'' ){

	for($i=0; $i<count($getCats); $i++)
		if( trim( $getCats[$i] )!='' )
	    	$storedoptions['rS_custom'][md5($user->_user_name)][trim( $getCats[$i] )] = $i+9000;

    if ( count($storedoptions['rS_custom'])>0 ){
	    foreach( array_keys($storedoptions['rS_custom']) as $uCat )
	        foreach( array_keys($storedoptions['rS_custom'][$uCat]) as $c )
            	$newItems .= '-' . $uCat .'-'. $storedoptions['rS_custom'][$uCat][$c] .','. trim($c) . '$$$';

	    $newItems       = substr($newItems,0 , -3);
	}

}


### autosave interval
if( $_POST['autosave']<>'' )
    $useroptions['rS_autosave'] = sanitize((int)$_POST['autosave']);


### email
$useroptions['rS_email'] = sanitize(_rem_magic_quote($_POST['email']),false,true);
### author
$useroptions['rS_author'] = sanitize(_rem_magic_quote($_POST['author']),false,true);


### background
if( $_POST['bgactive']<>'' )
    $useroptions['rS_background']['active'] = sanitize(_rem_magic_quote($_POST['bgactive']));


### passwords
$PWresetOK = $user->confirmUser($user->_user_name,md5(_rem_magic_quote($_POST['pwo'])));

if( $_POST['pw1'] != $_POST['pw2'] ){
	    $Rpw='. '.__('Password error!','recipeshelf');
		$pwErr = 'rs-config-pw1';
		$pwErrTxt = __('New passwords do not match!','recipeshelf');
}

if( $PWresetOK==2 ){
	    $Rpw='. '.__('Password error!','recipeshelf');
		$pwErr = 'rs-config-pwo';
		$pwErrTxt = __('Old password did not match!');
}


### 0 = ok, 2= wrong, 1=missing
if( !defined('LTDVERSION') && $PWresetOK == 0 && $_POST['pw1'] == $_POST['pw2'] && $_POST['pw1']!='' ){

	if( $r=$user->updatePW( $user->_user_name, _rem_magic_quote($_POST['pw1']) ) )
	    $Rpw='. '.__('Password updated!','recipeshelf');
 	else
	    $Rpw='. '.__('Password not updated!','recipeshelf');

	$pwErr = '';
	$pwErrTxt = '';
}

if( $_POST['pwo']=='' && $_POST['pw1']=='' && $_POST['pw2']=='' ){
	$Rpw='.';
	$pwErr = '';
	$pwErrTxt = '';
}

### save user options
$rSdb->update_option( $user->_user_name."_options",$useroptions );

if(  defined('LTDVERSION')  ){

	$newItems='';
	$Rpw='.';
	$pwErr = '';
	$pwErrTxt = '';
	echo 'DEMO VERSION! Only new background is saved' . '$%&' . unsanitize($newItems,false) . '$%&' . $pwErr . '$%&' . $pwErrTxt;

} else {

	if( $user->_readonly )
		$newItems='';

	$rSdb->update_option( "recipeShelf_options",$storedoptions );
	echo __('User options saved','recipeshelf') . $Rpw . '$%&' . unsanitize($newItems,false) . '$%&' . $pwErr . '$%&' . $pwErrTxt;

}
?>